﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <filesystem>

#include <gfxTool_CreateConvertArgOutput.h>
#include <gfxTool_CommandLineArg.h>

namespace nn {
namespace gfxTool {

void CreateConvertArgOutput::Initialize( const CommandLineArg* pInput )
{
    if( pInput->outputPath.IsExisting() )
    {
        m_OutputPath = std::tr2::sys::absolute(
            std::tr2::sys::path( pInput->outputPath.GetValue() ) ).string();
        this->outputPath.pValue = m_OutputPath.c_str();
        this->outputPath.length = NumericCastAuto( m_OutputPath.size() );
    }

    if( pInput->dumpDirectory.IsExisting() )
    {
        m_DumpDirectory = std::tr2::sys::absolute(
            std::tr2::sys::path( pInput->dumpDirectory.GetValue() ) ).string();
        if( m_DumpDirectory.back() != '/' )
        {
            m_DumpDirectory.push_back( '/' );
        }
        this->dumpDirectory.pValue = m_DumpDirectory.c_str();
        this->dumpDirectory.length = NumericCastAuto( m_DumpDirectory.size() );
    }
}

}
}
