﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include <gfxTool_Common.h>

namespace nn {
namespace gfxTool {

class VariationConstantDefinitionNode;
class PreprocessorDefinitionDefinitionNode;
class StageShaderVariationDefinitionNode;
class ShaderVariationDefinitionNode;

class VariationConstantDefinition
{
public:
    void Initialize( nngfxToolShaderCompilerVariationConstantDefinition* pArg,
        const VariationConstantDefinitionNode* pVariationConstantDefinitionNode, int index );

private:
    nngfxToolShaderCompilerVariationConstantDefinition* m_pArg;

    Custom< std::string >::Type m_Name;
};

class PreprocessorDefinitionDefinition
{
public:
    void Initialize( nngfxToolShaderCompilerPreprocessorDefinitionDefinition* pArg,
        const PreprocessorDefinitionDefinitionNode* pPreprocessorDefinitionDefinitionNode, int index );

private:
    nngfxToolShaderCompilerPreprocessorDefinitionDefinition* m_pArg;

    Custom< std::string >::Type m_Name;
};

class VariationDefinition
    : public nngfxToolShaderCompilerVariationDefinition
{
public:
    VariationDefinition()
        : nngfxToolShaderCompilerVariationDefinition()
    {
    }

    void Initialize( const StageShaderVariationDefinitionNode* pStageShaderVariationDefinitionNode );

private:
    Custom< std::vector< nngfxToolShaderCompilerVariationConstantDefinition
        > >::Type m_variationConstantDefinitionArrayRaw;
    Custom< std::vector< nngfxToolShaderCompilerPreprocessorDefinitionDefinition
        > >::Type m_preprocessorDefinitionDefinitionArrayRaw;

    Custom< std::string >::Type m_BufferName;

    Custom< std::vector< VariationConstantDefinition > >::Type m_variationConstantDefinitionArray;
    Custom< std::vector< PreprocessorDefinitionDefinition > >::Type m_preprocessordefinitionDefinitionArray;
};

class VariationDefinitionArg
    : public nngfxToolShaderCompilerVariationDefinitionArg
{
public:
    VariationDefinitionArg()
        : nngfxToolShaderCompilerVariationDefinitionArg()
    {
    }

    void Initialize( const ShaderVariationDefinitionNode* pShaderVariationDefinitionNode );

private:
    Custom< std::unique_ptr< VariationDefinition > >::Type m_pVariationDefinition[ ShaderStage::End ];
};

}
}
