﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <gfxTool_Common.h>
#include <gfxTool_CompilerManager.h>
#include <gfxTool_ShaderFileMerger.h>
#include <gfxTool_ShaderBinarizerContext.h>

namespace nn {
namespace gfxTool {

class ShaderConverterContext
{
public:
    typedef ShaderConverterContext SelfType;
    typedef nngfxToolHandle HandleType;

    enum class State
    {
        Created = 0x01,
        Converted = 0x02,
        Serialized = 0x04
    };

    ShaderConverterContext()
        : m_State( static_cast< int >( State::Created ) )
    {
    }

    static const int MajorVersion = nngfxToolShaderConverterVersion_Major;
    static const int MinorVersion = nngfxToolShaderConverterVersion_Minor;
    static const int MicroVersion = nngfxToolShaderConverterVersion_Micro;

    nngfxToolResultCode Reset();

    nngfxToolResultCode Convert( nngfxToolShaderConverterConvertOutput* pOutput,
        const nngfxToolShaderConverterConvertArg* pArg );

    nngfxToolResultCode Serialize( void* pOutBinary, size_t binarySize );

    static SelfType* Get( HandleType handle )
    {
        return reinterpret_cast< SelfType* >( handle );
    }

    static HandleType Create();

    static nngfxToolResultCode Delete( HandleType handle );

private:
    bool CheckState( State state )
    {
        return ( m_State & static_cast< int >( state ) ) != 0;
    }

    void AddState( State state )
    {
        m_State |= static_cast< int >( state );
    }

private:
    int m_State;

    ShaderBinarizerContext m_BinarizerContext;

    CompilerManager m_CompilerManager;
    ShaderFileMerger m_ShaderFileMerger;
};

}
}
