﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include <nn/utilTool/utilTool_BinarizerContext2.h>

#include <gfxTool_Common.h>
#include <gfxTool_BinarizerBase.h>
#include <gfxTool_ResShaderContainerBinarizer.h>
#include <nn/gfxTool/gfxTool_Util.h>

struct nngfxToolShaderCompilerCompileOutput;
struct nngfxToolShaderConverterConvertArg;

namespace nn {
namespace gfxTool {

class ShaderBinarizerContext
    : public nn::utilTool::BinarizerContext2
{
public:
    typedef nn::utilTool::BinarizerContext2 BaseBinarizerContext;

    ShaderBinarizerContext()
        : BaseBinarizerContext()
    {
    }

    void Reset();

    void CalculateSize( const nngfxToolShaderConverterConvertArg* pArg,
        const nngfxToolShaderCompilerCompileOutput* pOutput );

    void Serialize( void* pOutBinary, size_t memorySize );

    void AddMemoryBlock( int sectionIndex, BinarizerBase* pBinarizer )
    {
        m_pBinarizers.push_back( pBinarizer );
        AddMemoryBlock( sectionIndex, static_cast< nn::util::MemorySplitter::MemoryBlock* >( pBinarizer ) );
    }

    void AddMemoryBlock( int sectionIndex, nn::util::MemorySplitter::MemoryBlock* pBlock )
    {
        if( static_cast< Section >( sectionIndex ) == Section::ShaderBinary )
        {
            m_ShaderBinaryBlocks.push_back( pBlock );
        }
        BaseBinarizerContext::AddMemoryBlock( sectionIndex, pBlock );
    }

    void AddResDicMemoryBlock( int sectionIndex, nn::util::MemorySplitter::MemoryBlock* pBlock,
        const nn::util::string_view* pKeys, int entryCount )
    {
        if( static_cast< Section >( sectionIndex ) == Section::ShaderBinary )
        {
            m_ShaderBinaryBlocks.push_back( pBlock );
        }
        BaseBinarizerContext::AddResDicMemoryBlock( sectionIndex, pBlock, pKeys, entryCount );
    }

    template< typename T >
    void LinkPtr( const nn::util::MemorySplitter::MemoryBlock* pBlock,
        const nn::util::BinTPtr< T >* pBinPtr, const nn::util::MemorySplitter::MemoryBlock* pTarget )
    {
        if( pTarget && pTarget->GetSize() > 0 )
        {
            RegisterBinPtr( pBlock, NumericCastAuto( reinterpret_cast< uintptr_t >( pBinPtr ) ), pTarget );
        }
    }

    void LinkString( const nn::util::MemorySplitter::MemoryBlock* pBlock,
        nn::util::BinPtrToString* pBinPtrToString, const nn::util::string_view& str )
    {
        RegisterBinPtrToString( pBlock, NumericCastAuto(
            reinterpret_cast< uintptr_t >( pBinPtrToString ) ), str );
    }

    void LinkNativeString( const nn::util::MemorySplitter::MemoryBlock* pBlock,
        nn::util::BinPtrToString* pBinPtrToString, const nn::util::string_view& str )
    {
        LinkString( pBlock, pBinPtrToString, str );
        m_PtrToNativeString.emplace_back( pBlock,
            NumericCastAuto( reinterpret_cast<uintptr_t>( pBinPtrToString ) ) );
    }

    const Custom< std::vector< const nn::util::MemorySplitter::MemoryBlock* > >::Type&
        GetShaderBinaryBlocks()
    {
        return m_ShaderBinaryBlocks;
    }

private:
    Custom< std::vector< const nn::util::MemorySplitter::MemoryBlock* > >::Type m_ShaderBinaryBlocks;

    nn::util::MemorySplitter::MemoryBlock m_Header;
    ResShaderContainerBinarizer m_ResShaderContainerBinarizer;
    Custom< std::string >::Type m_Name;

    Custom< std::vector< BinarizerBase* > >::Type m_pBinarizers;

    nn::util::MemorySplitter::MemoryBlock m_BinarySectionPaddingBlock;

    Custom< std::vector< std::pair<
        const nn::util::MemorySplitter::MemoryBlock*, ptrdiff_t > > >::Type m_PtrToNativeString;
};

}
}
