﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include <nn/util/util_BinaryFormat.h>

#include <nn/gfx/gfx_Common.h>

#include <gfxTool_Common.h>
#include <gfxTool_BinarizerBase.h>

namespace nn {
namespace gfxTool {

class ShaderBinarizerContext;
class ResShaderVariationBinarizer;
class NvnShaderPoolBinarizer;

class ResShaderContainerBinarizer
    : public BinarizerBase
{
public:
    typedef nn::gfx::ResShaderContainerData ResTarget;
    typedef nngfxToolShaderCompilerCompileOutput BinarizationTarget;

    ResShaderContainerBinarizer();

    ~ResShaderContainerBinarizer();

    void Reset();

    void Initialize( const BinarizationTarget* pTarget,
        const nngfxToolShaderConverterConvertArg* pArg );

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void CalculateSize() override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;

    const nngfxToolShaderConverterConvertArg* GetArg() const
    {
        return m_pArg;
    }

    const Custom< std::vector< ResShaderVariationBinarizer > >::Type* GetVariationBinarizers() const
    {
        return &m_Variations;
    }

    Custom< std::vector< ResShaderVariationBinarizer > >::Type* GetVariationBinarizers()
    {
        return &m_Variations;
    }

private:
    const BinarizationTarget* m_pTarget;
    const nngfxToolShaderConverterConvertArg* m_pArg;

    int m_TargetLowLevelApiType;
    uint16_t m_TargetLowLevelApiVersion;

    Custom< std::vector< ResShaderVariationBinarizer > >::Type m_Variations;
    Custom< std::unique_ptr< NvnShaderPoolBinarizer > >::Type m_pShaderPoolBinarizer;
};

}
}
