﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/gfx/gfx_ResShaderData-api.nvn.h>

#include <gfxTool_Common.h>
#include <gfxTool_BinarizerBase.h>

namespace nn {
namespace gfxTool {

class ResShaderContainerBinarizer;

class NvnShaderPoolBinarizer
    : public BinarizerBase
{
public:
    typedef nn::gfx::NvnShaderPool ResTarget;

    void Initialize( ResShaderContainerBinarizer* pParent );

    virtual void RegisterChild( ShaderBinarizerContext* pContext ) override;
    virtual void CalculateSize() override;
    virtual void Convert( ShaderBinarizerContext* pContext ) override;
    virtual void Link( ShaderBinarizerContext* pContext ) override;

    static size_t GetMemoryPoolAlignment();
    static size_t GetMemoryPoolSizeGranularity();
    static size_t GetCodeTailRoomSize();

private:
    ResShaderContainerBinarizer* m_pParent;

    nn::util::MemorySplitter::MemoryBlock m_MemoryPool;

    bool m_IsMemoryPoolEnable;
};

}
}
