﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <fstream>
#include <mutex>

#if !defined( WIN32_LEAN_AND_MEAN )
    #define WIN32_LEAN_AND_MEAN
#endif
#if !defined( NOMINMAX )
    #define NOMINMAX
#endif
#include <nn/nn_Windows.h>

#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_ReadFile.h>

namespace nn {
namespace gfxTool {

bool ReadFile::Callback( void** ppOutFileData,
    size_t* pOutFileDataSize, const char* pFileName, void* pParam )
{
    static std::mutex s_Mutex;
    std::lock_guard< decltype( s_Mutex ) > lock( s_Mutex );

    auto pThis = static_cast< ReadFile* >( pParam );
    auto found = std::find_if( pThis->m_Files.begin(), pThis->m_Files.end(), [ pFileName ]
        ( const FileType& file ) { return file.first.compare( pFileName ) == 0; } );
    if( found != pThis->m_Files.cend() )
    {
        *ppOutFileData = &found->second[ 0 ];
        *pOutFileDataSize = found->second.size();
        return true;
    }

    HANDLE hFile = CreateFileA( pFileName, GENERIC_READ,
        FILE_SHARE_READ, nullptr, OPEN_EXISTING, 0, nullptr );
    if( hFile == INVALID_HANDLE_VALUE )
    {
        return false;
    }

    auto fileSize = GetFileSize( hFile, nullptr );
    Custom< std::vector< char > >::Type buffer( fileSize );
    DWORD read = 0;
    BOOL result = TRUE;
    if( fileSize > 0 )
    {
         result = ::ReadFile( hFile, &buffer[ 0 ], fileSize, &read, nullptr );
    }
    CloseHandle( hFile );
    if( result == FALSE || read != fileSize )
    {
        return false;
    }

    pThis->m_Files.emplace_back();
    pThis->m_Files.back().first = pFileName;
    pThis->m_Files.back().second = std::move( buffer );

    *ppOutFileData = pThis->m_Files.back().second.size() > 0 ?
        &pThis->m_Files.back().second[ 0 ] : nullptr;
    *pOutFileDataSize = pThis->m_Files.back().second.size();

    return true;
}

}
}
