﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_NvnGlslcDll.h>

namespace nn {
namespace gfxTool {

bool NvnGlslcDll::Initialize( const char* pDllPath )
{
    if( !DllBase::Initialize( pDllPath ) )
    {
        return false;
    }

    this->GlslcCompilePreSpecialized = GetRequiredFunction< decltype(
        this->GlslcCompilePreSpecialized ) >( "glslcCompilePreSpecialized" );
    this->GlslcCompileSpecialized = GetRequiredFunction< decltype(
        this->GlslcCompileSpecialized ) >( "glslcCompileSpecialized" );
    this->GlslcInitialize = GetRequiredFunction< decltype(
        this->GlslcInitialize ) >( "glslcInitialize" );
    this->GlslcFinalize = GetRequiredFunction< decltype(
        this->GlslcFinalize ) >( "glslcFinalize" );
    this->GlslcCompile = GetRequiredFunction< decltype(
        this->GlslcCompile ) >( "glslcCompile" );
    this->GlslcGetVersion = GetRequiredFunction< decltype(
        this->GlslcGetVersion ) >( "glslcGetVersion" );
    this->GlslcSetAllocator = GetFunction< decltype(
        this->GlslcSetAllocator ) >( "glslcSetAllocator" );
    this->GlslcGetDefaultOptions = GetRequiredFunction< decltype(
        this->GlslcGetDefaultOptions ) >( "glslcGetDefaultOptions" );
    this->GlslcWriteOutputsToDiskForDebugger = GetFunction< decltype(
        this->GlslcWriteOutputsToDiskForDebugger ) >( "glslcWriteOutputsToDiskForDebugger" );
    this->GlslcCompileSpecializedMT = GetFunction< decltype(
        this->GlslcCompileSpecializedMT ) >( "glslcCompileSpecializedMT" );
    this->GlslcFreeSpecializedResultsMT = GetFunction< decltype(
        this->GlslcFreeSpecializedResultsMT ) >( "glslcFreeSpecializedResultsMT" );
    this->GlslcCompareControlSections = GetFunction< decltype(
        this->GlslcCompareControlSections ) >( "glslcCompareControlSections" );
    this->GlslcGetDebugDataHash = GetFunction< decltype(
        this->GlslcGetDebugDataHash ) >( "glslcGetDebugDataHash" );
    this->GlslcSetDebugDataHash = GetFunction< decltype(
        this->GlslcSetDebugDataHash ) >( "glslcSetDebugDataHash" );

    return true;
}

const GLSLCresults* const * NvnGlslcDll::GlslcCompileSpecializedSt( GLSLCcompileObject* compileObject,
    const GLSLCspecializationBatch* specEntries )
{
    if( compileObject == nullptr || specEntries == nullptr )
    {
        NN_GFXTOOL_THROW( nngfxToolResultCode_InternalError );
    }

    auto ppOutput = this->GlslcCompileSpecialized( compileObject, specEntries );
    if( ppOutput == nullptr )
    {
        return nullptr;
    }

    GLSLCresults** ret = StaticCastAuto(
        malloc( sizeof( GLSLCresults* ) * specEntries->numEntries + 1 ) );
    ret[ specEntries->numEntries ] = nullptr;
    GLSLCresults* results = StaticCastAuto(
        malloc( sizeof( GLSLCresults ) * specEntries->numEntries ) );

    for( int idx = 0; idx < static_cast<int>( specEntries->numEntries ); ++idx )
    {
        ret[ idx ] = results + idx;
        if( compileObject->lastCompiledResults )
        {
            results[ idx ].compilationStatus = compileObject->lastCompiledResults->compilationStatus;
        }
        results[ idx ].glslcOutput = const_cast< GLSLCoutput* >( ppOutput[ idx ] );
    }

    return ret;
}

void NvnGlslcDll::GlslcFreeSpecializedResultsSt( const GLSLCresults* const * specResults )
{
    auto results = const_cast<GLSLCresults**>( specResults );
    if( results == nullptr )
    {
        NN_GFXTOOL_THROW( nngfxToolResultCode_InternalError );
    }

    for( auto ppResults = results; *ppResults; ++ppResults )
    {
        free( *ppResults );
    }
    free( results );
}

}
}
