﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/gfxTool/gfxTool_Util.h>

#include <gfxTool_GlobalWindow.h>

namespace {

auto& g_GlobalWindow = nn::gfxTool::GlobalWindow::GetInstance();

const char* GetWindowName()
{
    return "GfxShaderCompilerWindow";
}

}

namespace nn {
namespace gfxTool {

GlobalWindow::~GlobalWindow()
{
    if( m_hDc )
    {
        ::ReleaseDC( m_hWnd, m_hDc );
        m_hDc = nullptr;
    }

    if( m_hWnd )
    {
        ATOM atom = static_cast< ATOM >( GetClassLongA( m_hWnd, GCW_ATOM ) );
        DestroyWindow( m_hWnd );
        HINSTANCE hInstance = GetModuleHandleA( nullptr );
        if( hInstance )
        {
            UnregisterClassA( reinterpret_cast< LPCSTR >( atom ), hInstance );
        }
        m_hWnd = nullptr;
    }
}

void GlobalWindow::Initialize()
{
    HINSTANCE hInstance = GetModuleHandleA( nullptr );
    if( hInstance == nullptr )
    {
        NN_GFXTOOL_THROW_MSG(
            nngfxToolResultCode_FailedToCreateWindow, "%s", GetLastErrorString().c_str() );
    }

    WNDCLASSEXA winc = {
        sizeof( WNDCLASSEXA ),
        CS_OWNDC,
        DefWindowProcA,
        0,
        0,
        hInstance,
        nullptr,
        nullptr,
        nullptr,
        nullptr,
        GetWindowName(),
        nullptr
    };
    if( !RegisterClassExA( &winc ) )
    {
        NN_GFXTOOL_THROW_MSG(
            nngfxToolResultCode_FailedToCreateWindow, "%s", GetLastErrorString().c_str() );
    }

    if( ( m_hWnd = CreateWindowExA( 0, GetWindowName(), "", 0,
        CW_USEDEFAULT, CW_USEDEFAULT, 0, 0, nullptr, nullptr, hInstance, nullptr ) ) == nullptr )
    {
        NN_GFXTOOL_THROW_MSG(
            nngfxToolResultCode_FailedToCreateWindow, "%s", GetLastErrorString().c_str() );
    }

    if( ( m_hDc = ::GetDC( m_hWnd ) ) == nullptr )
    {
        NN_GFXTOOL_THROW_MSG(
            nngfxToolResultCode_FailedToCreateWindow, "%s", GetLastErrorString().c_str() );
    }
}

}
}
