﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nvnTool/nvnTool_GlslcInterface.h>
#include <nn/gfxTool/gfxTool_DllBase.h>

namespace nn {
namespace gfxTool {

class NvnGlslcDll
    : public DllBase
{
public:
    NvnGlslcDll()
        : DllBase()
        , GlslcCompilePreSpecialized()
        , GlslcCompileSpecialized()
        , GlslcInitialize()
        , GlslcFinalize()
        , GlslcCompile()
        , GlslcGetVersion()
        , GlslcSetAllocator()
        , GlslcGetDefaultOptions()
        , GlslcWriteOutputsToDiskForDebugger()
        , GlslcCompileSpecializedMT()
        , GlslcFreeSpecializedResultsMT()
        , GlslcCompareControlSections()
        , GlslcGetDebugDataHash()
        , GlslcSetDebugDataHash()
    {
    }

    virtual bool Initialize( const char* pDllPath ) override;

public:
    typedef GLSLCresults const * const * ( *glslcCompileSpecializedMTType )(
        const GLSLCcompileObject* compileObject, const GLSLCspecializationBatch* specEntries );
    typedef void( *glslcFreeSpecializedResultsMTType )( GLSLCresults const * const * specResults );

    decltype( &::glslcCompilePreSpecialized ) GlslcCompilePreSpecialized;
    decltype( &::glslcCompileSpecialized ) GlslcCompileSpecialized;
    decltype( &::glslcInitialize ) GlslcInitialize;
    decltype( &::glslcFinalize ) GlslcFinalize;
    decltype( &::glslcCompile ) GlslcCompile;
    decltype( &::glslcGetVersion ) GlslcGetVersion;
    decltype( &::glslcSetAllocator ) GlslcSetAllocator;
    decltype( &::glslcGetDefaultOptions ) GlslcGetDefaultOptions;
    decltype( &::glslcWriteOutputsToDiskForDebugger ) GlslcWriteOutputsToDiskForDebugger;
    glslcCompileSpecializedMTType GlslcCompileSpecializedMT;
    glslcFreeSpecializedResultsMTType GlslcFreeSpecializedResultsMT;
    decltype( &::glslcCompareControlSections ) GlslcCompareControlSections;
    decltype( &::glslcGetDebugDataHash ) GlslcGetDebugDataHash;
    decltype( &::glslcSetDebugDataHash ) GlslcSetDebugDataHash;

    // MT 版と同じインタフェースで旧 glslcCompileSpecialized を使うヘルパー
    const GLSLCresults * const * GlslcCompileSpecializedSt( GLSLCcompileObject* compileObject,
        const GLSLCspecializationBatch* specEntries );
    void GlslcFreeSpecializedResultsSt( const GLSLCresults * const * specResults );
};

}
}
