﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <memory>

#include <gfxTool_Compiler.h>

struct nngfxToolShaderCompilerCompileArg;

namespace nn {
namespace gfxTool {

class ShaderCompilerContext;
class CompileOutput;

class CompilerManager
{
public:
    CompilerManager();

    ~CompilerManager();

    void Compile( CompileOutput* pOutput, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg );

private:
    template< nngfxToolShaderCompilerLowLevelApiType >
    void CompileImpl( CompileOutput* pOutput, const ShaderCompilerContext* pContext,
        const nngfxToolShaderCompilerCompileArg* pArg );

    Custom< std::unique_ptr< CompilerBase > >::Type m_pSourceCompiler;
    Custom< std::unique_ptr< CompilerBase > >::Type m_pIntermediateCompiler;
    Custom< std::unique_ptr< CompilerBase > >::Type m_pBinaryCompiler;
};

}
}
