﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4F_MCS_COMMON_H_
#define NW4F_MCS_COMMON_H_

#if _MSC_VER > 1000 || defined(__CWCC__)
#pragma once
#endif

namespace nw4r
{
namespace mcs
{
namespace detail
{

//----------------------------------------------------------------------------
// OSReport関数を優先度の低いスレッドで実行している最中に、
// HIO2関数を呼び出すと失敗する場合があります。
// そのため、HIO2FuncRetryCountMaxで定めた回数分だけリトライを繰り返す処理を
// MCSライブラリ内部で、記述しています。
//
const int   HIO2FuncRetryCountMax   = 30;  //    (リトライ回数)
const int   HIO2FuncRetrySleepTime  = 8;   // ms (リトライ時待機時間、リトライ間隔)


const u32   MCS_INTERNAL_CHUNKHEADER_SIZE    = 0x20;
const u32   MCS_INTERNAL_CHUNKHEADER_LENGTH    = MCS_INTERNAL_CHUNKHEADER_SIZE / sizeof(u32);
// 内部バッファサイズ(送受信に用意されるので実際には *2 のサイズとなります。)
const u32   MCS_INTERNAL_BUFFER_SIZE    = 0x1000;

// PC側の送信最大データチャンクサイズ
const u32   MCS_INTERNAL_CHUNK_SIZE_MAX = 0x1000;



template<typename Type>
inline const Type&
GetMin(
    const Type& a,
    const Type& b
)
{
    return a < b ? a: b;
}

template<typename Type>
inline
Type
RoundUp(
    Type    value,
    u32     alignment
)
{
    return Type((u32(value) + alignment -1) & ~(alignment -1));
}

template<typename Type>
inline
Type
RoundDown(
    Type    value,
    u32     alignment
)
{
    return Type(u32(value) & ~(alignment -1));
}

#if defined(WIN32)

    inline void             SleepThread(u32 milSec) { Sleep(milSec); }

#else   // #if defined(WIN32)

    void                    SleepThread(u32 milSec);

#endif  // #if defined(WIN32)

}   // namespace detail
}   // namespace mcs
}   // namespace nw4r

/* NW4F_MCS_COMMON_H_ */
#endif
