﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.McsServer.McsUtil
{
    using System;
    using System.IO;
    using System.Net;

    /// <summary>
    /// 現時点では、全てのメソッドをoverrideしていないことに注意してください。
    /// </summary>
    public class NetBinaryReader : BinaryReader
    {
        public NetBinaryReader(Stream stream)
            : base(stream)
        {
        }

        public override short ReadInt16()
        {
            short val = base.ReadInt16();
            return IPAddress.NetworkToHostOrder(val);
        }

        public override ushort ReadUInt16()
        {
            ushort val = base.ReadUInt16();
            return (ushort)IPAddress.NetworkToHostOrder((short)val);
        }

        public override int ReadInt32()
        {
            int val = base.ReadInt32();
            return IPAddress.NetworkToHostOrder(val);
        }

        public override uint ReadUInt32()
        {
            uint val = base.ReadUInt32();
            return (uint)IPAddress.NetworkToHostOrder((int)val);
        }

        public override long ReadInt64()
        {
            long val = base.ReadInt64();
            return IPAddress.NetworkToHostOrder(val);
        }

        public override ulong ReadUInt64()
        {
            ulong val = base.ReadUInt64();
            return (ulong)IPAddress.NetworkToHostOrder((long)val);
        }
    }
}
