﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "TouchScreenInputer.h"


TouchScreenInputer::TouchScreenInputer(IoPortSender *sender)
{
    m_Sender = sender;
}

TouchScreenInputer::~TouchScreenInputer()
{
    ResetTouchState();
}

void TouchScreenInputer::CheckTouchId(int touchId)
{
    if (touchId < 0 || touchId >= MaxTouchCount)
    {
        throw InvalidTouchIdException(touchId);
    }
}

void TouchScreenInputer::CorrectPositionValue(int &x, int &y)
{
    if (x < 0)
    {
        x = 0;
    }
    if (y < 0)
    {
        y = 0;
    }
    if (x > 1280)
    {
        x = 1280;
    }
    if (y > 720)
    {
        y = 720;
    }
}


void TouchScreenInputer::ResetTouchState()
{
    m_Sender->ResetTouchState();
}

void TouchScreenInputer::SetTouchState(int touchIdList[], int fingerIdList[], float posXList[], float posYList[], int touchCount)
{
    int32_t xlist[MaxTouchCount] = {0};
    int32_t ylist[MaxTouchCount] = {0};
    for (int i = 0; i < touchCount; i++)
    {
        CheckTouchId(touchIdList[i]);
        xlist[i] = static_cast<int32_t>(posXList[i]);
        ylist[i] = static_cast<int32_t>(posYList[i]);
    }

    m_Sender->SetTouchState(touchIdList, fingerIdList, xlist, ylist, touchCount);
}

void TouchScreenInputer::PressDown(int touchId, int x, int y)
{
    CheckTouchId(touchId);
    CorrectPositionValue(x, y);

    m_Sender->SetTouchPress(touchId, x, y);
}

void TouchScreenInputer::PressDown(int touchId, int x, int y, int fingerId)
{
    CheckTouchId(touchId);
    CorrectPositionValue(x, y);

    m_Sender->SetTouchPress(touchId, x, y, fingerId);
}


void TouchScreenInputer::PressUp(int touchId)
{
    CheckTouchId(touchId);

    m_Sender->SetTouchRelease(touchId);
}

void TouchScreenInputer::MoveTo(int touchId, int x, int y)
{
    CheckTouchId(touchId);

    m_Sender->SetTouchMove(touchId, x, y);
}
