﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ControllerInterface.h"

ControllerInterface::ControllerInterface(IoPortSender *sender, int controllerId, PadInputer* pad)
    : m_IsManaged(true)
{
    m_Sender            = sender;
    m_ControllerId      = controllerId;

    m_Pad               = pad;

    m_ButtonController = new ButtonController(m_Pad);
}

ControllerInterface::~ControllerInterface()
{
    if (m_IsManaged)
    {
        Close();
    }

    delete m_ButtonController;
}

void ControllerInterface::Begin()
{
    m_Pad->BeginAutoPilot();
}

void ControllerInterface::Close()
{
    m_Pad->EndAutoPilot();
}

void ControllerInterface::SetDefault()
{
    m_Pad->SetDefault();
}

void ControllerInterface::SetState(Button buttonList[], int buttonCount, Stick stickList[], float stickDegreeList[], float stickPowerList[], int stickCount)
{
    m_ButtonController->SetState(buttonList, buttonCount, stickList, stickDegreeList, stickPowerList, stickCount);
}

void ControllerInterface::Press(Button button)
{
    m_ButtonController->Press(button);
}

void ControllerInterface::Release(Button button)
{
    m_ButtonController->Release(button);
}

void ControllerInterface::Push(Button button, int waitPress)
{
    m_ButtonController->Push(button, waitPress);
}

void ControllerInterface::PressMulti(Button buttonList[], int count)
{
    m_ButtonController->PressMulti(buttonList, count);
}

void ControllerInterface::ReleaseMulti(Button buttonList[], int count)
{
    m_ButtonController->ReleaseMulti(buttonList, count);
}

void ControllerInterface::PushMulti(Button buttonList[], int count, int waitPress)
{
    m_ButtonController->PushMulti(buttonList, count, waitPress);
}

void ControllerInterface::HoldAnalogStick(Stick stick, float degree, float power)
{
    m_ButtonController->HoldAnalogStick(stick, degree, power);
}

void ControllerInterface::ReleaseAnalogStick(Stick stick)
{
    m_ButtonController->ReleaseAnalogStick(stick);
}

void ControllerInterface::TiltAnalogStick(Stick stick, float degree, float power, int waitHold)
{
    m_ButtonController->TiltAnalogStick(stick, degree, power, waitHold);
}

void ControllerInterface::SetManagedStatus(bool isManaged)
{
    m_IsManaged = isManaged;
}
