﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#define _USE_MATH_DEFINES

#include <cmath>

#include "ControllerException.h"
#include "PadInputer.h"

class ButtonController
{
private:
    PadInputer              *m_Pad;

    void Degree2XyValue(ControllerStickValueType *pOutX, ControllerStickValueType *pOutY, float degree, float power);

public:
    explicit ButtonController(PadInputer *pad);
    ~ButtonController();

    void SetState(const Button buttonList[], int buttonCount,
        const Stick stickList[], const float stickDegreeList[], const float stickPowerList[], int stickCount);

    // 単一ボタン操作
    void Press(Button button);
    void Release(Button button);
    void Push(Button button, int waitPress);

    // 複数同時ボタン操作
    void PressMulti(const Button buttonList[], int count);
    void ReleaseMulti(const Button buttonList[], int count);
    void PushMulti(const Button buttonList[], int count, int waitPress);

    // アナログスティック
    void HoldAnalogStick(Stick stick, float degree, float power);
    void ReleaseAnalogStick(Stick stick);
    void TiltAnalogStick(Stick stick, float degree, float power, int waitPress);
};
