﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "Common\autoTestAssistTool_PathUtil.h"
#include <Windows.h>
#include <Shlwapi.h>

#pragma comment(lib, "Shlwapi.lib")

namespace autoTestAssistTool { namespace util {

    std::string GetSdkRootPath()
    {
        const DWORD BufferLength = 2048;
        TCHAR pathBuffer[BufferLength];

        if (::GetCurrentDirectory(BufferLength, pathBuffer) == 0)
        {
            throw std::exception("GetCurrentDirectory failed");
        }

        std::string currentDirectory = std::string(pathBuffer);

        while (true)
        {
            std::string sigloRootMarkFilePath = std::string(currentDirectory + "\\NintendoSdkRootMark");
            if (::PathFileExists(sigloRootMarkFilePath.c_str()))
            {
                return currentDirectory;
            }

            size_t lastDelimiterPos = currentDirectory.find_last_of("\\", currentDirectory.length());
            if (lastDelimiterPos == std::string::npos)
            {
                break;
            }
            currentDirectory = currentDirectory.substr(0, lastDelimiterPos);
        }

        memset(pathBuffer, 0, sizeof(TCHAR) * BufferLength);

        if (::GetEnvironmentVariable("NINTENDO_SDK_ROOT", pathBuffer, BufferLength) == 0)
        {
            throw std::exception("GetSdkRootPath failed");
        }

        return std::string(pathBuffer);
    }
}}

