﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <exception>
#include <iostream>
#include <Windows.h>

#include "Common\autoTestAssistTool_FpsController.h"

namespace autoTestAssistTool { namespace util {

    FpsController::FpsController(int fps)
        : m_FrameCount(0)
    {
        if (fps <= 0)
        {
            throw std::exception("Invalid FPS parameter is specified.");
        }

        m_Fps = fps;
        m_BeginLoopTime = std::chrono::system_clock::now();
    }

    FpsController::~FpsController()
    {
    }

    void FpsController::BeginLoop()
    {
        m_BeginLoopTime = std::chrono::system_clock::now();
        m_FrameCount = 0;
    }

    void FpsController::SleepFrameInterval()
    {
        // 待機時間計算
        int elapsedTime = static_cast<int>(std::chrono::duration_cast<std::chrono::milliseconds>(std::chrono::system_clock::now() - m_BeginLoopTime).count());
        int sleepTime = static_cast<int>((((m_FrameCount + 1.0f) / m_Fps) * 1000.0f) - elapsedTime);

        if (sleepTime > 0)
        {
            Sleep(sleepTime);
        }
        else
        {
            Sleep(1);
            ResetCount();
            return;
        }

        m_FrameCount = (m_FrameCount + 1) % m_Fps;
        if (m_FrameCount == 0)
        {
            m_BeginLoopTime = std::chrono::system_clock::now();
        }
    }

    void FpsController::EndLoop()
    {
        m_FrameCount = 0;
    }

    void FpsController::ResetCount()
    {
        m_FrameCount = 0;
        m_BeginLoopTime = std::chrono::system_clock::now();
    }
}}
