﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ShopMonitoringTool_UiValueItem.h"

IntegerItem::IntegerItem(std::string name, int defaultVal, int maxVal, int minVal)
{
    m_Name = name;
    m_IntegerValue = defaultVal;
    m_Max = maxVal;
    m_Min = minVal;
}
std::string IntegerItem::GetValueName()
{
    return std::to_string(m_IntegerValue);
}
void* IntegerItem::GetValue()
{
    return (void*)&m_IntegerValue;
}
Scene* IntegerItem::CallEnter()
{
    auto val = gKeyboard.GetInteger(m_IntegerValue);
    if (val)
    {
        m_IntegerValue = std::max(std::min(*val, m_Max), m_Min);
    }
    return nullptr;
}
void IntegerItem::CallIncrement()
{
    m_IntegerValue = std::min(m_IntegerValue + 1, m_Max);

}
void IntegerItem::CallDecrement()
{
    m_IntegerValue = std::max(m_IntegerValue - 1, m_Min);

}

BooleanItem::BooleanItem(std::string _name, bool defaultVal)
{
    m_Name = _name;
    m_BooleanValue = defaultVal;
}
std::string BooleanItem::GetValueName()
{
    return m_BooleanValue ? "true" : "false";
}
void* BooleanItem::GetValue()
{
    return (void*)&m_BooleanValue;
}
Scene* BooleanItem::CallEnter()
{
    m_BooleanValue = !m_BooleanValue;
    return nullptr;
}

StringItem::StringItem(std::string _name, std::string defaultVal)
{
    m_Name = _name;
    m_StringValue = defaultVal;
}
std::string StringItem::GetValueName()
{
    return m_StringValue;
}
void* StringItem::GetValue()
{
    return (void*)&m_StringValue;
}
Scene* StringItem::CallEnter()
{
    auto val = gKeyboard.GetIdString(m_StringValue);
    if (val)
    {
        m_StringValue = *val;
    }
    return nullptr;
}
