﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>

class Scene
{
public:
    enum class State
    {
        EnabledActive,      //現在のMENU
        EnabledInactive,    //非アクティブ
        Disabled,           //無効
    };
public:
    Scene();
    ~Scene();
    virtual void Draw() = 0;
    virtual void Update() = 0;
    virtual void Control() = 0;
    virtual std::string GetDescription() = 0;

    void SetDrawPos(int x, int y);
    Scene::State    GetState();
    void SetState(Scene::State state);
    void SetNextScene(Scene* pScene);
    void SetPrevScene(Scene* pScene);
protected:
    void EscapeScene();
protected:
    Scene* m_pNextScene;
    Scene* m_pPrevScene;
    int m_DrawPosX;
    int m_DrawPosY;
private:
    Scene::State    m_State;
};
