﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#ifndef gLog
#define gLog (Log::GetInstance())
#endif

#define APPLOG_DEBUG( ... )     (void)gLog.PrintToLog(Log::LogLevel::Debug,__VA_ARGS__);
#define APPLOG_INFO( ... )      (void)gLog.PrintToLog(Log::LogLevel::Info,__VA_ARGS__);
#define APPLOG_WARNING( ... )   (void)gLog.PrintToLog(Log::LogLevel::Warning,__VA_ARGS__);
#define APPLOG_ERROR( ... )     (void)gLog.PrintToLog(Log::LogLevel::Error,__VA_ARGS__);


class Log
{
public:
    static const int MaxLogBufferSize = 4096 * 1024;
    static const int WorkBufferSize = 4096 * 1024;
    static const int MaxLogLineSize = 10000;
    static const int TimeLogLength = 12;//"_[00:00:00]_"
    const char* TimeForm = " [%.2d:%.2d:%.2d] ";

    enum class LogLevel
    {
        Debug,
        Info,
        Warning,
        Error,
        Default = Info,
    };
    struct LogLine
    {
        int         m_LineNumber;
        LogLevel  m_LogLevel;
        int         m_BufferPos;
        size_t      m_BufferSize;
    } m_LogLine[MaxLogLineSize];

    int     m_BufferTailPos;
    int     m_LineCount;
    char    m_LogBuffer[MaxLogBufferSize];
    char    m_WorkBuffer[WorkBufferSize];
    nn::os::MutexType m_Mutex;
    void    PrintToLog(LogLevel _level,const char *fmt, ...) NN_NOEXCEPT;
    void    AppendLog(char *buf, LogLevel _level = LogLevel::Default) NN_NOEXCEPT;

    static Log& GetInstance() NN_NOEXCEPT;
    LogLine GetLine(int _lineNum) NN_NOEXCEPT;
    LogLevel GetLevel(int _lineNum) NN_NOEXCEPT;
    const char* GetBuffer(int _lineNum) NN_NOEXCEPT;
    int GetCount() NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    Log();
    ~Log();
};
