﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include <algorithm>
#include <nn/mem.h>
#include <nn/fs.h>

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForApplications.h>

#ifndef gFileSystem
#define gFileSystem (FileSystem::GetInstance())
#endif

class FileSystem
{
private:
    char* m_MountRomCacheBuffer = nullptr;
    const char* SaveFilePath = "save:/file";
public:
    static FileSystem& GetInstance() NN_NOEXCEPT;
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;
    void MountUserSaveData(int userIndex) NN_NOEXCEPT;
    bool IsUserSaveAvailable() NN_NOEXCEPT;
    void InitializeUserSaveData(char* initData, size_t dataSize) NN_NOEXCEPT;
    void ReadUserSaveData(char* readData, size_t dataSize) NN_NOEXCEPT;
    void WriteUserSaveData(char* fileData, size_t dataSize) NN_NOEXCEPT;
};
