﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include "qre.h"

using namespace mw::qre;

extern "C" {

bool mwqreQREncoderInitMemory(mwqreQREncoder* this_, void* ptr, uint32_t size)
{
    new (this_) QREncoder;
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->InitMemory(ptr, size);
}

bool mwqreQREncoderEncode(mwqreQREncoder* this_, mwqreEncodeData* qrInfo)
{
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->Encode(reinterpret_cast<EncodeData *>(qrInfo));
}

bool mwqreQREncoderEncodeWithImage(mwqreQREncoder* this_, mwqreEncodeData* qrInfo, const mwqreImageInfo* imageInfo)
{
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->EncodeWithImage(reinterpret_cast<EncodeData *>(qrInfo),
                              reinterpret_cast<const ImageInfo *>(imageInfo));
}

bool mwqreQREncoderGetErrorMessage(mwqreQREncoder* this_, char* pMess, int32_t size)
{
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->GetErrorMessage(pMess, size);
}

uint32_t mwqreQREncoderGetDivCount(mwqreQREncoder* this_)
{
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->GetDivCount();
}

uint32_t mwqreQREncoderGetVersion(mwqreQREncoder* this_)
{
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->GetVersion();
}

uint32_t mwqreQREncoderGetQRSize(mwqreQREncoder* this_, uint32_t index, bool isBmp)
{
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->GetQRSize(index, isBmp);
}

bool mwqreQREncoderGetQRBMPData(mwqreQREncoder* this_, uint8_t* buff, uint32_t size, uint32_t index, mwqreRect* pos)
{
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->GetQRBMPData(buff, size, index, reinterpret_cast<Rect *>(pos));
}

bool mwqreQREncoderGetQRData(mwqreQREncoder* this_, mwqreImageInfo* info, uint32_t index)
{
    QREncoder *p = reinterpret_cast<QREncoder *>(this_);
    return p->GetQRData(reinterpret_cast<ImageInfo *>(info), index);
}

uint32_t mwqreQREncoderGetEncodeBufferSize(uint32_t data_size, uint32_t cell_size, uint32_t count)
{
    return QREncoder::GetEncodeBufferSize(data_size, cell_size, count);
}

uint32_t mwqreQREncoderGetDesignQRImageSize(uint32_t version, uint32_t cellSize)
{
    return QREncoder::GetDesignQRImageSize(version, cellSize);
}

}
