﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * インクルード
 */
#include "QREL.h"

/*
 * 外部変数定義
 */
static ERRNO lasterror;

void InitLastError()
{
    lasterror = ERR_NOERROR;
}

/****************************************************************
 * 外部関数
 ****************************************************************/
/*
 * 関数名 QREL_GetLastError
 * 機能   エラー番号を取得する
 * 引数   なし
 * 戻り値 エラー番号を返す
 * 説明   エラー番号を取得する。
 */
ERRNO QREL_GetLastError()
{
    return lasterror;
}

/*
 * 関数名 QREL_SetLastError
 * 機能   エラー番号を設定する
 * 引数   err(IN)             エラー番号
 *          enforce(IN)       強制設定フラグ
 *                            trueのときは無条件に設定する。
 *                            falseのときは未設定のときのみ設定
 *                            する。
 * 戻り値 なし
 * 説明   エラー番号を設定する。
 */
void QREL_SetLastError(ERRNO err, bool enforce)
{
    if (enforce)
        lasterror = err;
    else if (lasterror == ERR_NOERROR)
        lasterror = err;
}
