﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <glv.h>
#include <glv_binding.h>
#include <glv_resources.h>
#include <functional>

class LabelButton : public glv::Button
{
public:
    explicit LabelButton(const std::string& text, std::function<void()> func) NN_NOEXCEPT
        : Button(glv::Rect(20), true), m_function(func)
    {
        this->add(FitButton(new glv::Label(text, false), 50, 4));
    }

    virtual bool onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT NN_OVERRIDE
    {
        switch (e)
        {
        case glv::Event::MouseDown:
        {
            m_function();

            this->remove();
        }
        break;
        default:
            break;
        }
        return true;
    }

private:
    std::function<void()> m_function;
    glv::Label* FitButton(glv::Label* pLabel, float fontSize, glv::space_t padding) NN_NOEXCEPT
    {
        pLabel->size(fontSize);
        pLabel->paddingX(padding);
        pLabel->paddingY(padding);
        pLabel->pos(glv::Place::CC, 0, 0).anchor(glv::Place::CC);
        glv::space_t width = (pLabel->width() + 1.f) / 2.f * 2.f;
        glv::space_t height = (pLabel->height() + 1.f) / 2.f * 2.f;
        glv::Button::extent(width, height);
        return pLabel;
    }
};
