﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Assert.h>

#include "NfpDebugTool_DisplayObject.h"

namespace nfpdebug { namespace ui {

/**
 * @brief   画面下部に常駐する、操作ヘルプを表示するオブジェクトです。
 */
class Footer : public DisplayObject
{
public:
    Footer() NN_NOEXCEPT :
        m_HelpText(nullptr)
    {
        SetPosition(0, 670);
    }

    /**
     * @brief   操作ヘルプ用の文字列を設定します。
     */
    void SetHelpText(const char* text) NN_NOEXCEPT
    {
        m_HelpText = text;
    }

    virtual void Render() NN_NOEXCEPT NN_OVERRIDE;

private:
    const char* m_HelpText;     //!< 操作ヘルプ
};

}}  // nfpdebug::ui
