﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/fs/fs_Bis.h>

namespace {
    const int BinaryBisPartitionNum = 8;
    const int BisPartitionNum = 4;
    const int PartitionNum = BinaryBisPartitionNum + BisPartitionNum;

    const nn::fs::BisPartitionId BinaryBisId[BinaryBisPartitionNum] = {
        nn::fs::BisPartitionId::BootConfigAndPackage2Part1,
        nn::fs::BisPartitionId::BootConfigAndPackage2Part2,
        nn::fs::BisPartitionId::BootConfigAndPackage2Part3,
        nn::fs::BisPartitionId::BootConfigAndPackage2Part4,
        nn::fs::BisPartitionId::BootConfigAndPackage2Part5,
        nn::fs::BisPartitionId::BootConfigAndPackage2Part6,
        nn::fs::BisPartitionId::BootPartition1Root,
        nn::fs::BisPartitionId::BootPartition2Root,
    };

    const nn::fs::BisPartitionId BisId[BisPartitionNum] = {
        nn::fs::BisPartitionId::CalibrationFile,
        nn::fs::BisPartitionId::SafeMode,
        nn::fs::BisPartitionId::System,
        nn::fs::BisPartitionId::User,
    };

    const char* BinaryPartitionName[BinaryBisPartitionNum] = {
        "BootConfigAndPackage2Part1",
        "BootConfigAndPackage2Part2",
        "BootConfigAndPackage2Part3",
        "BootConfigAndPackage2Part4",
        "BootConfigAndPackage2Part5",
        "BootConfigAndPackage2Part6",
        "BootPartition1Root",
        "BootPartition2Root",
    };

    const char* PartitionName[BisPartitionNum] = {
        "CalibrationFile",
        "SafeMode",
        "System",
        "User",
    };
}

