﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "VibrationDemo_VibrationButton.h"

namespace VibrationDemo
{
    VibrationButton::VibrationButton()
    {
        SetDefault();

        m_SourceCount = 0;
    }

    void VibrationButton::Update()
    {
        ++m_FrameCount;

        if (m_AnimationCount > 0)
        {
            --m_AnimationCount;
        }
        else
        {
            m_State.Reset<nns::hidfw::layout::LayoutState::Animation>();
        }

        if ((m_OldState.Test<nns::hidfw::layout::LayoutState::Selected>() != m_State.Test<nns::hidfw::layout::LayoutState::Selected>()))
        {
            if (m_Option.Test<nns::hidfw::layout::LayoutOption::OnOffMode>())
            {
                if (m_State.Test<nns::hidfw::layout::LayoutState::Selected>() && m_Option.Test<nns::hidfw::layout::LayoutOption::CallFunction>())
                {
                    CallFunc();
                }
            }
            m_AnimationCount = 7;
            m_State.Set<nns::hidfw::layout::LayoutState::Animation>();

            int key = nns::hidfw::layout::LayoutState::Selected::Index;
            auto vibItr = m_BnvibFileName.find(key);
            if (vibItr != m_BnvibFileName.end())
            {
                SetBnvibFile(vibItr->second.fileName.c_str(), vibItr->second.volume);
                PlayVibration(gControllerSequenceManager.GetMasterControllerId());
                PlayVibration(gControllerSequenceManager.GetMasterControllerId());
            }
            auto seItr = m_SoundFileName.find(key);
            if (seItr != m_SoundFileName.end())
            {
                gAudioManager.PlayWav(seItr->second.fileName.c_str(), 0.5f);
            }
        }
        else if (!m_Option.Test<nns::hidfw::layout::LayoutOption::OnOffMode>() && m_State.Test<nns::hidfw::layout::LayoutState::Selected>())
        {
            if (!m_State.Test<nns::hidfw::layout::LayoutState::Animation>())
            {
                if (m_Option.Test<nns::hidfw::layout::LayoutOption::CallFunction>())
                {
                    CallFunc();
                }
                Cancel();
                m_AnimationCount = 7;
            }
        }

        if (m_AnimationCount > 0)
        {
            if (m_State.Test<nns::hidfw::layout::LayoutState::Selected>())
            {
                m_Scale = nn::util::MakeFloat2(1.0f - (static_cast<float>(m_AnimationCount) / 70.f), 1.0f - (static_cast<float>(m_AnimationCount) / 70.f));
            }
            else if (m_State.Test<nns::hidfw::layout::LayoutState::Canceled>())
            {
                m_Scale = nn::util::MakeFloat2(1.f, 1.f);
            }
            else
            {
                m_Scale = nn::util::MakeFloat2(0.95f + (static_cast<float>(m_AnimationCount) / 70.f), 0.95f + (static_cast<float>(m_AnimationCount) / 70.f));
            }
        }
        else
        {
            if (m_State.Test<nns::hidfw::layout::LayoutState::Selected>())
            {
                m_Scale = nn::util::MakeFloat2(0.98f, 0.98f);
            }
            else
            {
                m_Scale = nn::util::MakeFloat2(1.f, 1.f);
            }
        }

        if (
            !m_OldState.Test<nns::hidfw::layout::LayoutState::Hover>() &&
            m_State.Test<nns::hidfw::layout::LayoutState::Hover>()
            )
        {
            int key = nns::hidfw::layout::LayoutState::Hover::Index;
            auto vibItr = m_BnvibFileName.find(key);
            if (vibItr != m_BnvibFileName.end())
            {
                SetBnvibFile(vibItr->second.fileName.c_str(), vibItr->second.volume);
                PlayVibration(gControllerSequenceManager.GetMasterControllerId());
                PlayVibration(gControllerSequenceManager.GetMasterControllerId());
            }
            auto seItr = m_SoundFileName.find(key);
            if (seItr != m_SoundFileName.end())
            {
                gAudioManager.PlayWav(seItr->second.fileName.c_str(), 0.5f);
            }
        }
    }

    void VibrationButton::PrintText()
    {
        gTextWriter.SetScale(m_Scale.x, m_Scale.y);

        const nn::util::Float2 textPos = nn::util::MakeFloat2(
            m_Pos.x + (m_Size.x - gTextWriter.CalculateStringWidth(m_Text.c_str())) / 2.f,
            m_Pos.y + (m_Size.y - gTextWriter.CalculateStringHeight(m_Text.c_str())) / 2.f);

        if (m_State.Test<nns::hidfw::layout::LayoutState::Selected>())
        {
            gTextWriter.SetTextColor(Color::Gray);
        }
        else
        {
            gTextWriter.SetTextColor(m_TextColor);
        }
        gTextWriter.SetCursor(textPos.x, textPos.y);
        gTextWriter.Print(m_Text.c_str());

        m_OldState = m_State;
        m_State.Set(nns::hidfw::layout::LayoutState::Canceled::Index, false);
    }

    void VibrationButton::Draw()
    {
        //!< 拡大率を考慮したボタンのサイズ
        const nn::util::Float2 buttonSize = nn::util::MakeFloat2(
            m_Size.x * m_Scale.x,
            m_Size.y * m_Scale.y);
        //!< 拡大率を考慮したボタンの位置
        const nn::util::Float2 buttonPos = nn::util::MakeFloat2(
            m_Pos.x - (buttonSize.x - m_Size.x) / 2.f,
            m_Pos.y - (buttonSize.y - m_Size.y) / 2.f);

        //!< ボタンに照準があっている場合の色
        nn::util::Color4u8 hoverColor = m_FocusColor;
        auto alpha = static_cast<uint8_t>(std::max(0.f, static_cast<float>(hoverColor.GetA()) - (((nn::util::SinEst(nn::util::DegreeToRadian((m_FrameCount % 120) * 3)) + 1.f) / 2.f ) * 120.f)));
        //auto alpha = static_cast<float>(hoverColor.GetA()) * ((nn::util::SinEst(nn::util::DegreeToRadian((m_FrameCount % 120) * 3)) + 1.f) / 4.f + 0.5f);
        hoverColor.SetA(alpha);

        //!< ボタンの影の色
        const nn::util::Color4u8 shadowColor = nn::util::Color4u8(10, 24, 48, 224);

        //!< 補正済みのボタンの色
        const nn::util::Color4u8 mainColor = m_MainColor;
        const nn::util::Color4u8 transparenceMainColor = nn::util::Color4u8(mainColor.GetR(), mainColor.GetG(), mainColor.GetB(), 0);
        //!< ボタン最下部の色
        const nn::util::Color4u8 subColor = nn::util::Color4u8::Lerp(mainColor, shadowColor, 0.55f);

        //!< ボタン選択時のエフェクトの色
        const auto effectColor = Color::Cyan;
        const auto transparenceEffectColor = nn::util::Color4u8(effectColor.GetR(), effectColor.GetG(), effectColor.GetB(), 0);

        const nn::util::Color4u8 black = nn::util::Color4u8(60, 70, 80, 255);
        const nn::util::Color4u8 blackZero = nn::util::Color4u8(60, 70, 80, 0);

        if (m_State.Test<nns::hidfw::layout::LayoutState::Selected>() || m_OldState.Test<nns::hidfw::layout::LayoutState::Canceled>())
        {
            if (m_State.Test<nns::hidfw::layout::LayoutState::Hover>())
            {
                auto pos = nn::util::MakeFloat2(m_Pos.x - 7.f, m_Pos.y - 7.f);
                auto size = nn::util::MakeFloat2(m_Size.x + 14.f, m_Size.y + 14.f);
                gDrawer.SetColor(effectColor);
                gDrawer.Draw2DRoundedFrame(pos, size, 0.4f, 24, 2.f);

                pos = nn::util::MakeFloat2(m_Pos.x - 7.f, m_Pos.y - 7.f);
                size = nn::util::MakeFloat2(m_Size.x + 14.f, m_Size.y + 14.f);
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Out, effectColor, transparenceEffectColor);
                gDrawer.Draw2DRoundedFrame(pos, size, 0.4f, 24, -1.f);

                pos = nn::util::MakeFloat2(m_Pos.x - 8.f, m_Pos.y - 8.f);
                size = nn::util::MakeFloat2(m_Size.x + 16.f, m_Size.y + 16.f);
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Out, effectColor, transparenceEffectColor);
                gDrawer.Draw2DRoundedFrame(pos, size, 0.4f, 24, 1.5f);
            }

            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_State.Test<nns::hidfw::layout::LayoutState::Hover>() ? effectColor : black, m_State.Test<nns::hidfw::layout::LayoutState::Hover>() ? transparenceMainColor : blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, 1.5f);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up, black, nn::util::Color4u8::Black());
            gDrawer.Draw2DRoundedRect(buttonPos, buttonSize, 0.4f, 24);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_State.Test<nns::hidfw::layout::LayoutState::Hover>() ? effectColor : black, m_State.Test<nns::hidfw::layout::LayoutState::Hover>() ? transparenceMainColor : blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, -1.f);
        }
        else
        {
            if (m_State.Test<nns::hidfw::layout::LayoutState::Hover>())
            {
                auto pos = nn::util::MakeFloat2(m_Pos.x - 7.f, m_Pos.y - 7.f);
                auto size = nn::util::MakeFloat2(m_Size.x + 14.f, m_Size.y + 14.f);
                gDrawer.SetColor(effectColor);
                gDrawer.Draw2DRoundedFrame(pos, size, 0.4f, 24, 2.f);

                pos = nn::util::MakeFloat2(m_Pos.x - 7.f, m_Pos.y - 7.f);
                size = nn::util::MakeFloat2(m_Size.x + 14.f, m_Size.y + 14.f);
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Out, effectColor, transparenceEffectColor);
                gDrawer.Draw2DRoundedFrame(pos, size, 0.4f, 24, -1.f);

                pos = nn::util::MakeFloat2(m_Pos.x - 8.f, m_Pos.y - 8.f);
                size = nn::util::MakeFloat2(m_Size.x + 16.f, m_Size.y + 16.f);
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Out, effectColor, transparenceEffectColor);
                gDrawer.Draw2DRoundedFrame(pos, size, 0.4f, 24, 1.5f);
            }
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, black, blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, 1.5f);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, black, blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, 1.5f);
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, mainColor, subColor);
            gDrawer.Draw2DRoundedRect(buttonPos, buttonSize, 0.4f, 24);
            if (m_State.Test<nns::hidfw::layout::LayoutState::Hover>())
            {
                gDrawer.SetColor(hoverColor);
                gDrawer.Draw2DRoundedRect(buttonPos, buttonSize, 0.4f, 24);
            }
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, black, blackZero);
            gDrawer.Draw2DRoundedFrame(buttonPos, buttonSize, 0.4f, 24, -1.f);
        }
    }
}
