﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <set>

#include "hidfw/gfx.h"
#include "hidfw/hid.h"
#include "hidfw/layout.h"

#include "VibrationDemo_Color.h"
#include "VibrationDemo_SceneBase.h"
#include "VibrationDemo_VibrationButton.h"
#include "VibrationDemo_VibrationSeekBar.h"
#include "VibrationDemo_VibrationSwitch.h"
#include "VibrationDemo_VibrationKnob.h"

namespace VibrationDemo
{
    class SceneUi : public SceneBase
    {
        NN_DISALLOW_COPY(SceneUi);
        NN_DISALLOW_MOVE(SceneUi);
    public:
        enum ListName
        {
            ListName_Normal,
            ListName_SoundOnly,
            ListName_Num
        };
    public:
        SceneUi() NN_NOEXCEPT;
        virtual ~SceneUi() NN_NOEXCEPT {}
    protected:
        void Initialize() NN_NOEXCEPT;
        void Update() NN_NOEXCEPT;
        void Draw() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;
    protected:
        typedef std::vector<std::tuple<nns::hidfw::layout::LayoutStateSet, std::string, float>> VibrationInfo;
        typedef std::vector<std::tuple<nns::hidfw::layout::LayoutStateSet, std::string, float>> SoundInfo;

        nns::hidfw::layout::ButtonGroup    m_FirstItemGroup;
        nns::hidfw::layout::ButtonGroup    m_ScondItemGroup;

        bool                        m_IsEnableVibration;

        VibrationSource<nn::hid::VibrationPlayer> m_VibrationSourcesForLeft[2];     //!< [0: Handheld] [1: NpadId::No1]
        VibrationSource<nn::hid::VibrationPlayer> m_VibrationSourcesForRight[2];    //!< [0: Handheld] [1: NpadId::No1]
    };
}
