﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

#include "hidfw/gfx.h"
#include "hidfw/gfx/gfx_FontSystem.h"
#include "hidfw/hid.h"
#include "hidfw/layout.h"

#include "VibrationDemo_VibrationManager.h"
#include "VibrationDemo_ControllerManager.h"
#include "VibrationDemo_Color.h"

namespace VibrationDemo
{
    class SceneBase
    {
        NN_DISALLOW_COPY(SceneBase);
        NN_DISALLOW_MOVE(SceneBase);
    public:
        SceneBase() NN_NOEXCEPT;

        virtual ~SceneBase() NN_NOEXCEPT {}

        void UpdateVibrationViewer() NN_NOEXCEPT;

        void DrawVibrationViewer() NN_NOEXCEPT;

        bool DoMainLoop() NN_NOEXCEPT;

        void ExitScene() NN_NOEXCEPT;

        void ExitApplication() NN_NOEXCEPT;

        void StartCheckController(const nn::hid::NpadStyleSet enableStyle, const int8_t minPlayerCount, const int8_t maxPlayerCount) NN_NOEXCEPT
        {
            NN_UNUSED(enableStyle);
            NN_UNUSED(minPlayerCount);
            NN_UNUSED(maxPlayerCount);
        }

    protected:
        virtual void Initialize() NN_NOEXCEPT = 0;

        virtual void Update() NN_NOEXCEPT = 0;

        virtual void Draw() NN_NOEXCEPT = 0;

        virtual void Finalize() NN_NOEXCEPT = 0;
    protected:
        static bool                        m_IsShowVibration;
        static bool                        m_IaMoveVibrationViewer;
        bool m_IsExit;
        bool m_SceneResult;
        int  m_FrameCount;
    private:
        static nns::hidfw::layout::BaseItemSet    m_VibrationViewer;
        static nns::hidfw::layout::LineChart      m_FrequencyDrawerForLeft;
        static nns::hidfw::layout::BarChart       m_AmplitudeDrawerForLeft;
        static nns::hidfw::layout::LineChart      m_FrequencyDrawerForRight;
        static nns::hidfw::layout::BarChart       m_AmplitudeDrawerForRight;
    };
}
