﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "File.h"
#include "Button.h"
#include "Drawer.h"

namespace VibrationCollection
{
    nn::gfx::ResTextureFile*    g_pResTextureFile;
    int32_t                     g_TextureIndex[4];
    nn::gfx::DescriptorSlot     g_TextureDescriptor[4];
    nn::gfx::DescriptorSlot     g_SamplerDescriptor;
    nn::gfx::Sampler            g_Sampler;

    TextureInfo                 g_NpadButtonIconSet;
    TextureInfo                 g_NpadStyleIconSet;
    TextureInfo                 g_ToolIconSet;

    void SetupNpadStyleIconSet() NN_NOEXCEPT
    {
        g_NpadStyleIconSet.textureIndex = g_TextureIndex[1];
        g_NpadStyleIconSet.divSize = nn::util::MakeFloat2(64.f, 64.f);
        g_NpadStyleIconSet.size = nn::util::MakeFloat2(256.f, 256.f);
        // 基本セット
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleFullKey::Index, 0), 0));
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleHandheld::Index, 0), 1));
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleJoyDual::Index, 0), 2));
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleJoyLeft::Index, 0), 3));
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleJoyRight::Index, 0), 4));
        // 一本横もち (左右共用)
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleJoyLeft::Index, 1), 5));
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleJoyRight::Index, 1), 5));
        // 左コン横もち
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleJoyLeft::Index, 2), 6));
        // 右コン横もち
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleJoyRight::Index, 2), 7));
        // KUINA
        g_NpadStyleIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadStyleJoyDual::Index, 1), 8));
    }

    void SetupNpadButtonIconset() NN_NOEXCEPT
    {
        g_NpadButtonIconSet.textureIndex = g_TextureIndex[2];
        IconIndex idx = 0;
        g_NpadButtonIconSet.divSize = nn::util::MakeFloat2(64.f, 64.f);
        g_NpadButtonIconSet.size = nn::util::MakeFloat2(512.f, 1024.f);
        // 白線、透明色抜きのボタンアイコン
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::A::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::B::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::X::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Y::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::L::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::R::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::ZL::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::ZR::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickLUp::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickRUp::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Up::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickLDown::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickRDown::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Down::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickLRight::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickRRight::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Right::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickLLeft::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickRLeft::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Left::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Plus::Index, 0),   idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Minus::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Plus::Index, 2), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Minus::Index, 2), idx++));
        // 塗りつぶしボタンアイコン
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::A::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::B::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::X::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Y::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::L::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::R::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::ZL::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::ZR::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickLUp::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickRUp::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Up::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickLDown::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickRDown::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Down::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickLRight::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickRRight::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Right::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickLLeft::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickRLeft::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Left::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Plus::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Minus::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Plus::Index, 3), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Minus::Index, 3), idx++));
         // 白線、透明色抜きの十字キー
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::Cross::Index, 2), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Up::Index, 2), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Down::Index, 2), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Left::Index, 2), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Right::Index, 2), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::UpDown::Index, 2), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::LeftRight::Index, 2), idx++));
        idx++;      // 空白
        // 塗りつぶし十字キー
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::Cross::Index, 3), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Up::Index, 3), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Down::Index, 3), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Left::Index, 3), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Right::Index, 3), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::UpDown::Index, 3), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::LeftRight::Index, 3), idx++));
        idx++;
        // 4つセットの透明色抜き方向キー
        idx++;
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Right::Index, 4), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Down::Index, 4), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Up::Index, 4), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::Left::Index, 4), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::UpDown::Index, 4), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::LeftRight::Index, 4), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::AllDirections::Index, 1), idx++));
        // 特殊キー
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadJoyButton::LeftSL::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadJoyButton::RightSL::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadJoyButton::LeftSR::Index, 0), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadJoyButton::RightSR::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::Home::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::Capture::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadJoyButton::LeftSL::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadJoyButton::RightSL::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadJoyButton::LeftSR::Index, 1), idx));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadJoyButton::RightSR::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::Home::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(NpadIconButton::Capture::Index, 1), idx++));
        // 白線、透明色抜きのスティック
        idx++;
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickL::Index, 0), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickR::Index, 0), idx++));
        idx++;
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickL::Index, 2), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickR::Index, 2), idx++));
        idx++;
        idx++;
        // 塗りつぶしスティック
        idx++;
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickL::Index, 1), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickR::Index, 1), idx++));
        idx++;
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickL::Index, 3), idx++));
        g_NpadButtonIconSet.iconSet.insert(TexturePair(TextureKey::Make(nn::hid::NpadButton::StickR::Index, 3), idx++));
        idx++;
        idx++;
        // 特殊アイコン
    } // NOLINT(impl/function_size)

    void SetupToolIconSet() NN_NOEXCEPT
    {
        g_ToolIconSet.textureIndex = g_TextureIndex[3];
        IconIndex idx = 0;
        g_ToolIconSet.divSize = nn::util::MakeFloat2(64.f, 64.f);
        g_ToolIconSet.size = nn::util::MakeFloat2(128.f, 128.f);
        // 白線、透明色抜きのボタンアイコン
        g_ToolIconSet.iconSet.insert(TexturePair(TextureKey::Make(ToolIcon::Pc::Index, 0), idx++));
        g_ToolIconSet.iconSet.insert(TexturePair(TextureKey::Make(ToolIcon::Sd::Index, 0), idx++));
    }

    void DrawFileSlector(float x, float y) NN_NOEXCEPT
    {
        auto clearColor = gDrawer.GetClearColor();
        // 背景色が暗色か確認を行います (原則白か黒となるため厳密な判定は行いません)
        bool isLightColor = (clearColor.GetR() + clearColor.GetR() + clearColor.GetR()) / 3.f >= 128;
        nn::util::Float2 pos = NN_UTIL_FLOAT_2_INITIALIZER(x, y);
        //====================================================
        // テキスト描画
        //====================================================
        // 参照先
        pos.x += 104.f;
        gTextWriter.SetFixedWidth(11.f);
        gTextWriter.SetFixedWidthEnabled(true);
        gTextWriter.SetTextColor(nn::util::Color4u8(96, 96, 96, 128));
        gTextWriter.SetCursor(pos.x, pos.y + 5.f);
        gTextWriter.Print("%.43s", gFileManager.GetTempRootPath());
        gTextWriter.SetTextColor(nn::util::Color4u8(252, 252, 252, 255));
        gTextWriter.SetCursor(pos.x + 1.f, pos.y + 6.f);
        gTextWriter.Print("%.43s", gFileManager.GetTempRootPath());
        gTextWriter.SetFixedWidthEnabled(false);

        //====================================================
        // 図形描画
        //====================================================
        pos = nn::util::MakeFloat2(x, y);
        gDrawer.SetColor(gFileManager.GetTempMountType() == MountType_Sd ? isLightColor ? nn::util::Color4u8::Blue() : nn::util::Color4u8::Cyan() : nn::util::Color4u8(64, 64, 64, 128));
        DrawToolIcon(
            nn::util::MakeFloat2(pos.x, pos.y),
            nn::util::MakeFloat2(0.5f, 0.5f),
            ToolIcon::Sd::Mask
        );
        gDrawer.SetColor(gFileManager.GetTempMountType() == MountType_Host ? isLightColor ? nn::util::Color4u8::Blue() : nn::util::Color4u8::Cyan() : nn::util::Color4u8(64, 64, 64, 128));
        DrawToolIcon(
            nn::util::MakeFloat2(pos.x + 48.f, pos.y),
            nn::util::MakeFloat2(0.5f, 0.5f),
            ToolIcon::Pc::Mask
        );
        // 参照先
        bool isNeedReload = gFileManager.IsNeedReload();
        nn::util::Color4u8 color1 = isNeedReload ? nn::util::Color4u8(128, 32, 32, 255) : isLightColor ? nn::util::Color4u8(32, 32, 32, 255) : nn::util::Color4u8(8, 8, 8, 255);
        nn::util::Color4u8 color2 = isNeedReload ? nn::util::Color4u8(162, 64, 48, 255) : isLightColor ? nn::util::Color4u8(96, 96, 96, 255) : nn::util::Color4u8(64, 64, 64, 255);

        pos.x += 96.f;
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, color1, color2);
        gDrawer.Draw2DRoundedRect(pos, nn::util::MakeFloat2(492.f, 32.f), 0.2f, 64);
        gDrawer.SetColor(nn::util::Color4u8(64, 64, 64, 255));
        gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(492.f, 32.f), 0.2f, 64, 1);
    }

    void DrawBnvibList(float x, float y) NN_NOEXCEPT
    {
        NN_UNUSED(x);
        NN_UNUSED(y);
        //====================================================
        // テキスト描画
        //====================================================
        auto clearColor = gDrawer.GetClearColor();
        // 背景色が暗色か確認を行います (原則白か黒となるため厳密な判定は行いません)
        bool isLightColor = (clearColor.GetR() + clearColor.GetR() + clearColor.GetR()) / 3.f >= 128;
        gTextWriter.SetTextColor(isLightColor? nn::util::Color4u8(0, 30, 8, 255) : nn::util::Color4u8::Green());
        gTextWriter.SetCursor(444.f + 8.f, 112.f);
        gTextWriter.Print("Bnvib Files ( %d Files )", gFileManager.GetBnvibFileCount());
        gTextWriter.SetTextColor(nn::util::Color4u8::Black());
        gTextWriter.SetCursor(444.f + 12.f, 155.f);
        gTextWriter.Print("No    FileName                              Time");
        gTextWriter.SetTextColor(nn::util::Color4u8::White());
        gTextWriter.SetCursor(444.f + 12.f, 153.f);
        gTextWriter.Print("No    FileName                              Time");
        //====================================================
        // 図形描画
        //====================================================
        // フォーカス時には光彩をつける
        if (g_ButtonGroup[ApplicationButtonGroup_Vibration].IsFocus())
        {
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8(0, 224, 8, 255), nn::util::Color4u8(128, 255, 28, 8));
            gDrawer.Draw2DFrame(nn::util::MakeFloat2(444.f, 152.f), nn::util::MakeFloat2(387.f, 504.f), 12.f);
        }
        // リストの背景 (透明)
        gDrawer.SetColor(nn::util::Color4u8(255, 255, 255, 0));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(444.f, 152.f), nn::util::MakeFloat2(387.f, 504.f));
        // 見出し
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8(0, 112, 192, 255), nn::util::Color4u8(0, 40, 82, 255));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(444.f, 152.f), nn::util::MakeFloat2(370.f, 24.f));
        // スクロールバー
        float vibBarScale = 10.f / std::max(10.f, static_cast<float>(gFileManager.GetBnvibFileCount()));
        float vibBarPos = ((504.f - 504.f * vibBarScale) / std::max(1.f, static_cast<float>(gFileManager.GetBnvibFileCount()) - 10.f)) * g_BnvibButtonStartIndex;
        gDrawer.SetColor(
            nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Right,
            nn::util::Color4u8(2, 3, 8, 128),
            nn::util::Color4u8(2, 3, 8, 0));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(814.f, 152.f), nn::util::MakeFloat2(8.f, 504.f));
        gDrawer.SetColor(nn::util::Color4u8(192, 83, 17, 255));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(814.f, 152.f + vibBarPos), nn::util::MakeFloat2(17.f, 504.f * vibBarScale));
        gDrawer.SetColor(
            nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Right,
            nn::util::Color4u8(192, 83, 17, 255),
            nn::util::Color4u8(144, 60, 15, 255));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(814.f + 7, 152.f + vibBarPos), nn::util::MakeFloat2(10.f, 504.f * vibBarScale));
        //====================================================
        // リスト内描画
        //====================================================
        auto textColor = isLightColor ? nn::util::Color4u8::Blue() : nn::util::Color4u8::Cyan();
        auto borderColor = isLightColor ? nn::util::Color4u8::Black() : nn::util::Color4u8::Gray();

        bool isVisibleSelectButton = (g_SelectedBnvibButtonInedx >= g_BnvibButtonStartIndex && g_SelectedBnvibButtonInedx < g_BnvibButtonStartIndex + g_ButtonCount);

        for (int i = 0; i < g_ButtonCount; ++i)
        {
            if (i == g_ButtonGroup[ApplicationButtonGroup_Vibration].GetSelectedItemIndex() && isVisibleSelectButton)
            {
                gDrawer.SetColor(
                    nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up,
                    nn::util::Color4u8(44, 119, 125, 255),
                    nn::util::Color4u8(29, 76, 96, 255));
                gDrawer.Draw2DRect(
                    nn::util::MakeFloat2(444.f, 176.f + i * 48.f),
                    nn::util::MakeFloat2(370.f, 48.f));
                gDrawer.SetColor(
                    nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up,
                    nn::util::Color4u8(2, 3, 4, 8),
                    nn::util::Color4u8(2, 3, 4, 198));
                gDrawer.Draw2DRect(
                    nn::util::MakeFloat2(444.f, 176.f + i * 48.f),
                    nn::util::MakeFloat2(370.f, 18.f));
            }
            else
            {
                gDrawer.SetColor(
                    nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up,
                    nn::util::Color4u8(2, 3, 24, 96),
                    nn::util::Color4u8(2, 3, 24, 0));
                gDrawer.Draw2DRect(
                    nn::util::MakeFloat2(444.f, 176.f + i * 48.f + 16.f),
                    nn::util::MakeFloat2(370.f, 32.f));
            }
            if (g_ButtonGroup[ApplicationButtonGroup_Vibration].IsFocus() && i == g_ButtonGroup[ApplicationButtonGroup_Vibration].GetFocusItemIndex())
            {
                if (g_ButtonGroup[ApplicationButtonGroup_Vibration].GetFocusItemIndex() == g_ButtonGroup[ApplicationButtonGroup_Vibration].GetSelectedItemIndex() && isVisibleSelectButton)
                {
                    gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up, nn::util::Color4u8(255, 255, 96, 96), nn::util::Color4u8(255, 255, 255, 0));
                }
                else
                {
                    gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up, nn::util::Color4u8(245, 226, 169, 255), nn::util::Color4u8(212, 168, 112, 96));
                }
                gDrawer.Draw2DRect(
                    nn::util::MakeFloat2(444.f, 176.f + i * 48.f),
                    nn::util::MakeFloat2(370.f, 48.f));
            }
            gDrawer.SetColor(borderColor);
            gDrawer.Draw2DLine(
                nn::util::MakeFloat2(444.f, 176.f + i * 48.f),
                nn::util::MakeFloat2(814.f, 176.f + i * 48.f));

            if (g_BnvibButtonStartIndex + i < gFileManager.GetBnvibFileCount())
            {
                gTextWriter.SetTextColor((i == g_ButtonGroup[ApplicationButtonGroup_Vibration].GetSelectedItemIndex() && isVisibleSelectButton) ? nn::util::Color4u8::White() : textColor);

                gTextWriter.SetCursor(444.f + 8.f, 190.f + i * 48.f);
                gTextWriter.Print("%03d", g_BnvibButtonStartIndex + i);
                gTextWriter.SetCursor(444.f + 64.f, 190.f + i * 48.f);

                bool isLoopEnable = (gFileManager.GetBnvibFile().at(g_BnvibButtonStartIndex + i).Loop.isLoop != 0);
                std::string fileName = gFileManager.GetBnvibFile().at(g_BnvibButtonStartIndex + i).FileName;
                size_t extPos = gFileManager.GetBnvibFile().at(g_BnvibButtonStartIndex + i).FileName.rfind('.');
                if (extPos != std::string::npos) {
                    fileName = gFileManager.GetBnvibFile().at(g_BnvibButtonStartIndex + i).FileName.substr(0, extPos);
                }
                gTextWriter.Print("%.24s", fileName.c_str());
                gTextWriter.SetCursor(444.f + 312.f, 190.f + i * 48.f);
                if (isLoopEnable)
                {
                    auto loopTextColor = nn::util::Color4u8(textColor.GetB(), textColor.GetG(), textColor.GetR(), textColor.GetA());
                    gTextWriter.SetTextColor((i == g_ButtonGroup[ApplicationButtonGroup_Vibration].GetSelectedItemIndex() && isVisibleSelectButton) ? nn::util::Color4u8::Yellow() : loopTextColor);
                    gTextWriter.Print("Loop");
                }
                else
                {
                    double playTime = gFileManager.GetBnvibFile().at(g_BnvibButtonStartIndex + i).Time.GetMilliSeconds();
                    playTime /= 1000.f;
                    gTextWriter.Print("%4.3f", playTime);
                }
            }
        }
        // リストの外枠
        gDrawer.SetColor(borderColor);
        gDrawer.Draw2DFrame(nn::util::MakeFloat2(444.f, 152.f), nn::util::MakeFloat2(370.f, 504.f), 1.f);
        // スクロールバー用の外枠
        gDrawer.Draw2DFrame(nn::util::MakeFloat2(815.f, 152.f), nn::util::MakeFloat2(16.f, 504.f), 1.f);
        // 線
        gDrawer.Draw2DLine(nn::util::MakeFloat2(444.f, 176.f), nn::util::MakeFloat2(814.f, 176.f));
        gDrawer.Draw2DLine(nn::util::MakeFloat2(492.f, 152.f), nn::util::MakeFloat2(492.f, 656.f));
        gDrawer.Draw2DLine(nn::util::MakeFloat2(748.f, 152.f), nn::util::MakeFloat2(748.f, 656.f));
    } // NOLINT(impl/function_size)

    void DrawAudioList(float x, float y) NN_NOEXCEPT
    {
        NN_UNUSED(x);
        NN_UNUSED(y);
        //====================================================
        // テキスト描画
        //====================================================
        auto clearColor = gDrawer.GetClearColor();
        // 背景色が暗色か確認を行います (原則白か黒となるため厳密な判定は行いません)
        bool isLightColor = (clearColor.GetR() + clearColor.GetR() + clearColor.GetR()) / 3.f >= 128;
        gTextWriter.SetTextColor(isLightColor ? nn::util::Color4u8(0, 30, 8, 255) : nn::util::Color4u8::Green());
        gTextWriter.SetCursor(862.f + 8.f, 112.f);
        gTextWriter.Print("Audio Files ( %d Files )", gFileManager.GetAudioFileCount());
        gTextWriter.SetTextColor(nn::util::Color4u8::Black());
        gTextWriter.SetCursor(862.f + 12.f, 155.f);
        gTextWriter.Print("No    FileName                              Ext");
        gTextWriter.SetTextColor(nn::util::Color4u8::White());
        gTextWriter.SetCursor(862.f + 12.f, 153.f);
        gTextWriter.Print("No    FileName                              Ext");
        //====================================================
        // 図形描画
        //====================================================
        // フォーカス時には光彩をつける
        if (g_ButtonGroup[ApplicationButtonGroup_Audio].IsFocus())
        {
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8(0, 224, 8, 255), nn::util::Color4u8(128, 255, 28, 8));
            gDrawer.Draw2DFrame(nn::util::MakeFloat2(862.f, 152.f), nn::util::MakeFloat2(387.f, 504.f), 12.f);
        }
        // リストの背景色 (透明)
        gDrawer.SetColor(nn::util::Color4u8(255, 255, 255, 0));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(862.f, 152.f), nn::util::MakeFloat2(387.f, 504.f));
        // 見出し
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8(0, 112, 192, 255), nn::util::Color4u8(0, 40, 82, 255));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(862.f, 152.f), nn::util::MakeFloat2(370.f, 24.f));
        // スクロールバー
        float audioBarScale = 10.f / std::max(10.f, static_cast<float>(gFileManager.GetAudioFileCount()));
        float audioBarPos = ((504.f - 504.f * audioBarScale) / std::max(1.f, static_cast<float>(gFileManager.GetAudioFileCount()) - 10.f)) * g_AudioButtonStartIndex;
        gDrawer.SetColor(
            nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Right,
            nn::util::Color4u8(2, 3, 8, 128),
            nn::util::Color4u8(2, 3, 8, 0));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(1233.f, 152.f), nn::util::MakeFloat2(8.f, 504.f));
        gDrawer.SetColor(nn::util::Color4u8(192, 83, 17, 255));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(1233.f, 152.f + audioBarPos), nn::util::MakeFloat2(16.f, 504.f * audioBarScale));
        gDrawer.SetColor(
            nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Right,
            nn::util::Color4u8(192, 83, 17, 255),
            nn::util::Color4u8(144, 60, 15, 255));
        gDrawer.Draw2DRect(nn::util::MakeFloat2(1233.f + 7, 152.f + audioBarPos), nn::util::MakeFloat2(10.f, 504.f * audioBarScale));
        //====================================================
        // リスト内描画
        //====================================================
        auto textColor = isLightColor ? nn::util::Color4u8::Blue() : nn::util::Color4u8::Cyan();
        auto borderColor = isLightColor ? nn::util::Color4u8::Black() : nn::util::Color4u8::Gray();
        bool isVisibleSelectButton = (g_SelectedAudioButtonIndex >= g_AudioButtonStartIndex && g_SelectedAudioButtonIndex < g_AudioButtonStartIndex + g_ButtonCount);

        for (int i = 0; i < g_ButtonCount; ++i)
        {
            if (i == g_ButtonGroup[ApplicationButtonGroup_Audio].GetSelectedItemIndex() && isVisibleSelectButton)
            {
                gDrawer.SetColor(
                    nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up,
                    nn::util::Color4u8(237, 86, 84, 255),
                    nn::util::Color4u8(176, 21, 19, 255));
                gDrawer.Draw2DRect(
                    nn::util::MakeFloat2(862.f, 176.f + i * 48.f),
                    nn::util::MakeFloat2(370.f, 48.f));
                gDrawer.SetColor(
                    nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up,
                    nn::util::Color4u8(2, 3, 4, 8),
                    nn::util::Color4u8(2, 3, 4, 198));
                gDrawer.Draw2DRect(
                    nn::util::MakeFloat2(862.f, 176.f + i * 48.f),
                    nn::util::MakeFloat2(370.f, 18.f));
            }
            else
            {
                gDrawer.SetColor(
                    nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up,
                    nn::util::Color4u8(2, 3, 24, 96),
                    nn::util::Color4u8(2, 3, 24, 0));
                gDrawer.Draw2DRect(
                    nn::util::MakeFloat2(862.f, 176.f + i * 48.f + 16.f),
                    nn::util::MakeFloat2(370.f, 32.f));
            }
            if (g_ButtonGroup[ApplicationButtonGroup_Audio].IsFocus() && i == g_ButtonGroup[ApplicationButtonGroup_Audio].GetFocusItemIndex())
            {
                if (g_ButtonGroup[ApplicationButtonGroup_Audio].GetFocusItemIndex() == g_ButtonGroup[ApplicationButtonGroup_Audio].GetSelectedItemIndex())
                {
                    gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up, nn::util::Color4u8(255, 255, 96, 96), nn::util::Color4u8(255, 255, 255, 0));
                }
                else
                {
                    gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up, nn::util::Color4u8(245, 226, 169, 255), nn::util::Color4u8(212, 168, 112, 96));
                }
                gDrawer.Draw2DRect(
                    nn::util::MakeFloat2(862.f, 176.f + i * 48.f),
                    nn::util::MakeFloat2(370.f, 48.f));
            }
            gDrawer.SetColor(borderColor);
            gDrawer.Draw2DLine(
                nn::util::MakeFloat2(862.f, 176.f + i * 48.f),
                nn::util::MakeFloat2(1232.f, 176.f + i * 48.f));
            gTextWriter.SetTextColor((i == g_ButtonGroup[ApplicationButtonGroup_Audio].GetSelectedItemIndex() && isVisibleSelectButton) ? nn::util::Color4u8::White() : textColor);
            if ((g_AudioButtonStartIndex + i) < gFileManager.GetAudioFileCount())
            {
                gTextWriter.SetCursor(862.f + 8.f, 190.f + i * 48.f);
                gTextWriter.Print("%03d", g_AudioButtonStartIndex + i);
                gTextWriter.SetCursor(862.f + 64.f, 190.f + i * 48.f);

                std::string fileName = gFileManager.GetAudioFile().at(g_AudioButtonStartIndex + i).FileName;
                size_t extPos = gFileManager.GetAudioFile().at(g_AudioButtonStartIndex + i).FileName.rfind('.');
                if (extPos != std::string::npos) {
                    fileName = gFileManager.GetAudioFile().at(g_AudioButtonStartIndex + i).FileName.substr(0, extPos);
                }
                gTextWriter.Print("%.24s", fileName.c_str());
                gTextWriter.SetCursor(862.f + 312.f, 190.f + i * 48.f);
                gTextWriter.Print("%s",
                    gFileManager.GetAudioFile().at(g_AudioButtonStartIndex + i).FileType == AudioFileData::FileType_Wave ? "Wave" :
                    gFileManager.GetAudioFile().at(g_AudioButtonStartIndex + i).FileType == AudioFileData::FileType_Adpcm ? "Adpcm" : "Unknown");

            }
        }
        // リストの外枠
        gDrawer.SetColor(borderColor);
        gDrawer.Draw2DFrame(nn::util::MakeFloat2(862.f, 152.f), nn::util::MakeFloat2(370.f, 504.f), 1.f);
        // スクロールバー用の外枠
        gDrawer.Draw2DFrame(nn::util::MakeFloat2(1233.f, 152.f), nn::util::MakeFloat2(16.f, 504.f), 1.f);
        // 線
        gDrawer.Draw2DLine(nn::util::MakeFloat2(862.f, 176.f), nn::util::MakeFloat2(1232.f, 176.f));
        gDrawer.Draw2DLine(nn::util::MakeFloat2(910.f, 152.f), nn::util::MakeFloat2(910.f, 656.f));
        gDrawer.Draw2DLine(nn::util::MakeFloat2(1166.f, 152.f), nn::util::MakeFloat2(1166.f, 656.f));
    } // NOLINT(impl/function_size)

    void CalcList() NN_NOEXCEPT
    {
        bool isVisibleSelectButton = (g_SelectedBnvibButtonInedx >= g_BnvibButtonStartIndex && g_SelectedBnvibButtonInedx < g_BnvibButtonStartIndex + g_ButtonCount);

        if (g_BnvibButtonStartIndex > gFileManager.GetBnvibFileCount() || gFileManager.GetBnvibFileCount() - g_BnvibButtonStartIndex < 10)
        {
            g_BnvibButtonStartIndex = std::max(gFileManager.GetBnvibFileCount(), 10) - 10;
        }
        if (g_ButtonGroup[ApplicationButtonGroup_Vibration].GetFocusItemIndex() == g_ButtonCount)
        {
            // 下移動
            if (g_BnvibButtonStartIndex + g_ButtonCount < gFileManager.GetBnvibFileCount())
            {
                ++g_BnvibButtonStartIndex;
                if (isVisibleSelectButton)
                {
                    if (g_ButtonGroup[ApplicationButtonGroup_Vibration].GetSelectedItemIndex() > 0)
                    {
                        g_ButtonGroup[ApplicationButtonGroup_Vibration].SelectItem(g_SelectedBnvibButtonInedx - g_BnvibButtonStartIndex, false);
                    }
                }
            }
            g_ButtonGroup[ApplicationButtonGroup_Vibration].FocusItem(g_ButtonCount - 1);
        }
        else if (g_ButtonGroup[ApplicationButtonGroup_Vibration].GetFocusItemIndex() == g_ButtonCount + 1)
        {
            // 上移動
            if (g_BnvibButtonStartIndex > 0)
            {
                --g_BnvibButtonStartIndex;
                if (isVisibleSelectButton)
                {
                    if (g_ButtonGroup[ApplicationButtonGroup_Vibration].GetSelectedItemIndex() < g_ButtonCount)
                    {
                        g_ButtonGroup[ApplicationButtonGroup_Vibration].SelectItem(g_SelectedBnvibButtonInedx - g_BnvibButtonStartIndex, false);
                    }
                }
            }
            else
            {
                if (g_ButtonGroup[ApplicationButtonGroup_Vibration].IsFocus())
                {
                    g_ButtonGroup[ApplicationButtonGroup_Vibration].Focus(false);
                    g_ButtonGroup[ApplicationButtonGroup_File].SetNextItemSet(&g_ButtonGroup[ApplicationButtonGroup_Vibration]);
                    g_ButtonGroup[ApplicationButtonGroup_File].Focus(true);
                }
            }
            g_ButtonGroup[ApplicationButtonGroup_Vibration].FocusItem(0);
        }

        isVisibleSelectButton = (g_SelectedAudioButtonIndex >= g_AudioButtonStartIndex && g_SelectedAudioButtonIndex < g_AudioButtonStartIndex + g_ButtonCount);

        if (g_AudioButtonStartIndex > gFileManager.GetAudioFileCount() || gFileManager.GetAudioFileCount() - g_AudioButtonStartIndex < 10)
        {
            g_AudioButtonStartIndex = std::max(gFileManager.GetAudioFileCount(), 10) - 10;
        }
        if (g_ButtonGroup[ApplicationButtonGroup_Audio].GetFocusItemIndex() == g_ButtonCount)
        {
            // 下移動
            if (g_AudioButtonStartIndex + g_ButtonCount < gFileManager.GetAudioFileCount())
            {
                ++g_AudioButtonStartIndex;
                if (isVisibleSelectButton)
                {
                    if (g_ButtonGroup[ApplicationButtonGroup_Audio].GetSelectedItemIndex() > 0)
                    {
                        g_ButtonGroup[ApplicationButtonGroup_Audio].SelectItem(g_SelectedAudioButtonIndex - g_AudioButtonStartIndex, false);
                    }
                }
            }
            g_ButtonGroup[ApplicationButtonGroup_Audio].FocusItem(g_ButtonCount - 1);
        }
        else if (g_ButtonGroup[ApplicationButtonGroup_Audio].GetFocusItemIndex() == g_ButtonCount + 1)
        {
            // 上移動
            if (g_AudioButtonStartIndex > 0)
            {
                --g_AudioButtonStartIndex;
                if (isVisibleSelectButton)
                {
                    if (g_ButtonGroup[ApplicationButtonGroup_Audio].GetSelectedItemIndex() < g_ButtonCount)
                    {
                        g_ButtonGroup[ApplicationButtonGroup_Audio].SelectItem(g_SelectedAudioButtonIndex - g_AudioButtonStartIndex, false);
                    }
                }
            }
            else
            {
                if (g_ButtonGroup[ApplicationButtonGroup_Audio].IsFocus())
                {
                    g_ButtonGroup[ApplicationButtonGroup_Audio].Focus(false);
                    g_ButtonGroup[ApplicationButtonGroup_File].SetNextItemSet(&g_ButtonGroup[ApplicationButtonGroup_Audio]);
                    g_ButtonGroup[ApplicationButtonGroup_File].Focus(true);
                }
            }
            g_ButtonGroup[ApplicationButtonGroup_Audio].FocusItem(0);
        }
    }

    void ScrollBnvibList() NN_NOEXCEPT
    {
        auto oldBnvibButtonStartIndex = g_BnvibButtonStartIndex;

        std::vector<nns::hidfw::layout::BaseItem*>& list = g_ButtonGroup[ApplicationButtonGroup_Vibration].GetItemSet();

        nn::util::Float2 pos = list.at(0)->GetPos();
        nn::util::Float2 size;
        size.x = list.at(g_ButtonCount - 1)->GetPos().x + list.at(g_ButtonCount - 1)->GetSize().x - pos.x;
        size.y = list.at(g_ButtonCount - 1)->GetPos().y + list.at(g_ButtonCount - 1)->GetSize().y - pos.y;

        static nn::util::Float2 gesturePos;
        static auto temp = g_BnvibButtonStartIndex;
        static bool isStartTouch = false;

        nn::hid::GestureType gestureType;
        nn::hid::GestureState gestureState;
        if (gTouch.GetGestureState(&gestureType, &gestureState, pos, size))
        {
            if (gestureType == nn::hid::GestureType_Touch)
            {
                isStartTouch = true;
                temp = g_BnvibButtonStartIndex;
                gesturePos = nn::util::MakeFloat2(gestureState.x, gestureState.y);
            }
            if (isStartTouch && gestureType == nn::hid::GestureType_Pan)
            {
                if (temp + (gesturePos.y - gestureState.y) / 16.f > 0)
                {
                    if (
                        gFileManager.GetBnvibFileCount() > g_ButtonCount &&
                        temp + (gesturePos.y - gestureState.y) / 16.f < gFileManager.GetBnvibFileCount() - g_ButtonCount
                        )
                    {
                        g_BnvibButtonStartIndex = temp + (gesturePos.y - gestureState.y) / 16.f;
                    }
                    else
                    {
                        g_BnvibButtonStartIndex = std::max(gFileManager.GetBnvibFileCount(), g_ButtonCount) - g_ButtonCount;
                    }
                }
                else
                {
                    g_BnvibButtonStartIndex = 0;
                }
            }
            if (
                gestureType == nn::hid::GestureType_Complete ||
                gestureType == nn::hid::GestureType_Idle
                )
            {
                isStartTouch = false;
            }
        }

        if (
            oldBnvibButtonStartIndex != g_BnvibButtonStartIndex &&
            g_SelectedBnvibButtonInedx >= g_BnvibButtonStartIndex &&
            g_SelectedBnvibButtonInedx - g_BnvibButtonStartIndex < g_ButtonCount
            )
        {
            g_ButtonGroup[ApplicationButtonGroup_Vibration].SelectItem(g_SelectedBnvibButtonInedx - g_BnvibButtonStartIndex, false);
        }
    }

    void ScrollAudioList() NN_NOEXCEPT
    {
        auto oldAudioButtonStartIndex = g_AudioButtonStartIndex;

        std::vector<nns::hidfw::layout::BaseItem*>& list = g_ButtonGroup[ApplicationButtonGroup_Audio].GetItemSet();

        nn::util::Float2 pos = list.at(0)->GetPos();
        nn::util::Float2 size;
        size.x = list.at(g_ButtonCount - 1)->GetPos().x + list.at(g_ButtonCount - 1)->GetSize().x - pos.x;
        size.y = list.at(g_ButtonCount - 1)->GetPos().y + list.at(g_ButtonCount - 1)->GetSize().y - pos.y;

        static nn::util::Float2 gesturePos;
        static auto temp = g_AudioButtonStartIndex;
        static bool isStartTouch = false;

        nn::hid::GestureType gestureType;
        nn::hid::GestureState gestureState;
        if (gTouch.GetGestureState(&gestureType, &gestureState, pos, size))
        {
            if (gestureType == nn::hid::GestureType_Touch)
            {
                isStartTouch = true;
                temp = g_AudioButtonStartIndex;
                gesturePos = nn::util::MakeFloat2(gestureState.x, gestureState.y);
            }
            if (isStartTouch && gestureType == nn::hid::GestureType_Pan)
            {
                if (temp + (gesturePos.y - gestureState.y) / 16.f > 0)
                {
                    if (
                        gFileManager.GetAudioFileCount() > g_ButtonCount &&
                        temp + (gesturePos.y - gestureState.y) / 16.f < gFileManager.GetAudioFileCount() - g_ButtonCount
                        )
                    {
                        g_AudioButtonStartIndex = temp + (gesturePos.y - gestureState.y) / 16.f;
                    }
                    else
                    {
                        g_AudioButtonStartIndex = std::max(g_ButtonCount, gFileManager.GetAudioFileCount()) - g_ButtonCount;
                    }
                }
                else
                {
                    g_AudioButtonStartIndex = 0;
                }
            }
            if (
                gestureType == nn::hid::GestureType_Complete ||
                gestureType == nn::hid::GestureType_Idle
                )
            {
                isStartTouch = false;
            }
        }

        if (
            oldAudioButtonStartIndex != g_AudioButtonStartIndex &&
            g_SelectedAudioButtonIndex >= g_AudioButtonStartIndex &&
            g_SelectedAudioButtonIndex - g_AudioButtonStartIndex < g_ButtonCount
            )
        {
            g_ButtonGroup[ApplicationButtonGroup_Audio].SelectItem(g_SelectedAudioButtonIndex - g_AudioButtonStartIndex, false);
        }
    }

    void DrawBackGround() NN_NOEXCEPT
    {
        DrawTitle();
    }

    void DrawMainMenu() NN_NOEXCEPT
    {
        gTextWriter.SetTextColor(nn::util::Color4u8(0, 104, 55, 255));

        ScrollBnvibList();
        ScrollAudioList();

        CalcList();

        DrawFileSlector(444.f, 32.f);

        DrawBnvibList(444.f, 112.f);
        DrawAudioList(862.f, 112.f);
    }

    void DrawStatusBar() NN_NOEXCEPT
    {
        gDrawer.SetColor(nn::util::Color4u8(0, 0, 0, 255));
        gDrawer.Draw2DLine(
            nn::util::MakeFloat2(420.f, 0.f),
            nn::util::MakeFloat2(420.f, gGraphics.GetGraphicsSystem().GetScreenHeight()));

        gDrawer.SetColor(nn::util::Color4u8(50, 89, 72, 255));
        gDrawer.Draw2DRect(
            nn::util::MakeFloat2(0, gGraphics.GetGraphicsSystem().GetScreenHeight() - 48.f),
            nn::util::MakeFloat2(gGraphics.GetGraphicsSystem().GetScreenWidth(), 48.f));

        nn::oe::DisplayVersion ver;
        nn::oe::GetDisplayVersion(&ver);

        gDrawer.SetColor(nn::util::Color4u8::White());
        gTextWriter.SetTextColor(nn::util::Color4u8::White());
        nn::util::Float2 pos = nn::util::MakeFloat2(16.f, gGraphics.GetGraphicsSystem().GetScreenHeight() - 32.f);
        gTextWriter.SetCursor(pos.x, pos.y);
        gTextWriter.Print("Vibration Collection v.%s", ver.value);
        gTextWriter.SetCursorX(350.f);
        pos.x = gTextWriter.GetCursorX() - 36.f;
        DrawNpadButton(nn::util::MakeFloat2(pos.x, pos.y - 6.f), nn::util::MakeFloat2(0.5f, 0.5f), nn::hid::NpadButton::Plus::Mask, ButtonIconType_Border);
        gTextWriter.Print("or");
        gTextWriter.SetCursorX(420.f);
        pos.x = gTextWriter.GetCursorX() - 48.f;
        DrawNpadButton(nn::util::MakeFloat2(pos.x, pos.y - 6.f), nn::util::MakeFloat2(0.5f, 0.5f), nn::hid::NpadButton::Minus::Mask, ButtonIconType_Border);
        gTextWriter.Print("Show Setting");
        gTextWriter.SetCursorX(620.f);
        pos.x = gTextWriter.GetCursorX() - 48.f;
        DrawNpadButton(nn::util::MakeFloat2(pos.x, pos.y - 6.f), nn::util::MakeFloat2(0.5f, 0.5f), nn::hid::NpadButton::X::Mask, ButtonIconType_Border);
        gTextWriter.Print("Play Vibration");
        gTextWriter.SetCursorX(820.f);
        pos.x = gTextWriter.GetCursorX() - 48.f;
        DrawNpadButton(nn::util::MakeFloat2(pos.x, pos.y - 6.f), nn::util::MakeFloat2(0.5f, 0.5f), nn::hid::NpadButton::A::Mask, ButtonIconType_Border);
        gTextWriter.Print("Select Item");
        gTextWriter.SetCursorX(1000.f);
        pos.x = gTextWriter.GetCursorX() - 38.f;
        DrawNpadButton(nn::util::MakeFloat2(pos.x, pos.y - 6.f), nn::util::MakeFloat2(0.5f, 0.5f), NpadIconButton::AllDirections::Mask, ButtonIconType_Fill);
        gTextWriter.Print("or");
        gTextWriter.SetCursorX(1070.f);
        pos.x = gTextWriter.GetCursorX() - 48.f;
        DrawNpadButton(nn::util::MakeFloat2(pos.x, pos.y - 6.f), nn::util::MakeFloat2(0.5f, 0.5f), NpadIconButton::Cross::Mask, ButtonIconType_Border_2);
        gTextWriter.Print("Choose Item");
    }

    void* ReadResource(nn::mem::StandardAllocator* memory, const char* filename) NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(memory);
        NN_ASSERT_NOT_NULL(filename);

        nn::gfx::Sampler::InfoType info;
        info.SetDefault();
        info.SetFilterMode(nn::gfx::FilterMode_MinLinear_MagLinear_MipLinear);
        info.SetAddressU(nn::gfx::TextureAddressMode_Mirror);
        info.SetAddressV(nn::gfx::TextureAddressMode_Mirror);
        info.SetAddressW(nn::gfx::TextureAddressMode_Mirror);

        g_Sampler.Initialize(&gGraphics.GetGraphicsSystem().GetDevice(), info);
        gGraphics.GetGraphicsSystem().RegisterSamplerSlot(&g_SamplerDescriptor, g_Sampler);

        nn::Result result;
        nn::fs::FileHandle hFile;

        int64_t fileSize = 0;
        result = nn::fs::OpenFile(&hFile, filename, nn::fs::OpenMode_Read);
        NN_ASSERT(result.IsSuccess());

        result = nn::fs::GetFileSize(&fileSize, hFile);
        NN_ASSERT(result.IsSuccess());

        nn::util::BinaryFileHeader fileHeader;
        size_t readSize;
        result = nn::fs::ReadFile(&readSize, hFile, 0, &fileHeader, sizeof(nn::util::BinaryFileHeader));
        NN_ASSERT(result.IsSuccess());
        NN_ASSERT(readSize == sizeof(nn::util::BinaryFileHeader));
        size_t alignment = fileHeader.GetAlignment();

        void* pBuffer = memory->Allocate(static_cast<size_t>(fileSize), static_cast<size_t>(alignment));
        result = nn::fs::ReadFile(&readSize, hFile, 0, pBuffer, static_cast< size_t >(fileSize));
        NN_ASSERT(result.IsSuccess());
        NN_ASSERT(readSize == static_cast< size_t >(fileSize));

        nn::fs::CloseFile(hFile);

        return pBuffer;
    }

    void InitializeResource(nn::mem::StandardAllocator* memory) NN_NOEXCEPT
    {
        NN_ASSERT_NOT_NULL(memory);

        void* g_MountRomCacheBuffer = nullptr;
        size_t cacheSize = 0;
        nn::Result result;
        result = nn::fs::QueryMountRomCacheSize(&cacheSize);
        NN_ABORT_UNLESS(result.IsSuccess());

        g_MountRomCacheBuffer = malloc(cacheSize);
        NN_ABORT_UNLESS_NOT_NULL(g_MountRomCacheBuffer);

        result = nn::fs::MountRom("Contents", g_MountRomCacheBuffer, cacheSize);
        NN_ABORT_UNLESS(result.IsSuccess());

        // タイトル画像を読み込みます

        void* pTextureResource = ReadResource(memory, "Contents:/Texture.bntx");
        g_pResTextureFile = nn::gfx::ResTextureFile::ResCast(pTextureResource);
        g_pResTextureFile->Initialize(&gGraphics.GetGraphicsSystem().GetDevice());
        for (int idxTexture = 0, textureCount = g_pResTextureFile->GetTextureDic()->GetCount();
            idxTexture < textureCount; ++idxTexture)
        {
            g_pResTextureFile->GetResTexture(idxTexture)->Initialize(&gGraphics.GetGraphicsSystem().GetDevice());

        }
        const char* textureFileNames[] = {
            "Title", "StyleIcon", "ButtonIcon", "ToolIcon"
        };
        for (size_t i = 0; i < NN_ARRAY_SIZE(textureFileNames); ++i)
        {
            g_TextureIndex[i] = g_pResTextureFile->GetTextureDic()->FindIndex(textureFileNames[i]);
            NN_ASSERT(g_TextureIndex[i] != -1);
            gGraphics.GetGraphicsSystem().RegisterTextureViewSlot(&g_TextureDescriptor[i], *static_cast<nn::gfx::TextureView*>(g_pResTextureFile->GetResTexture(g_TextureIndex[i])->GetTextureView()));
        }

        nn::fs::Unmount("Contents");

        free(g_MountRomCacheBuffer);
        g_MountRomCacheBuffer = nullptr;
    }

    void DrawTitleLogo(const nn::util::Float2& pos, const nn::util::Float2& size) NN_NOEXCEPT
    {
        nns::gfx::PrimitiveRenderer::Renderer* pRenderer = &(gGraphics.GetGraphicsSystem().GetPrimitiveRenderer());
        nns::gfx::PrimitiveRenderer::PrimitiveMesh mesh;

        static const nn::util::Float2 ScreenSize = NN_UTIL_FLOAT_2_INITIALIZER(1280, 720);

        static const uint32_t index[6] =
        {
            0, 1, 2, 0, 2, 3
        };

        if (mesh.Initialize(pRenderer->GetGpuBuffer(), 4, 6,
            (nns::gfx::PrimitiveRenderer::VertexFormat)(nns::gfx::PrimitiveRenderer::VertexFormat_Pos | nns::gfx::PrimitiveRenderer::VertexFormat_Color | nns::gfx::PrimitiveRenderer::VertexFormat_Uv)) == false)
        {
            return;
        }

        uint32_t* pIndexData = mesh.GetIndexBufferCpuAddress();

        for (size_t i = 0; i < NN_ARRAY_SIZE(index); ++i)
        {
            pIndexData[i] = index[i];
        }

        nn::util::Float3* pPos = static_cast<nn::util::Float3*>(mesh.GetVertexBufferCpuAddress(nns::gfx::PrimitiveRenderer::VertexAttribute_Pos));
        pPos[0] = nn::util::MakeFloat3(
            -1.f + (2.f * (pos.x)) / ScreenSize.x,
            1.f - (2.f * (pos.y)) / ScreenSize.y,
            0);
        pPos[1] = nn::util::MakeFloat3(
            -1.f + (2.f * (pos.x + size.x)) / ScreenSize.x,
            1.f - (2.f * (pos.y)) / ScreenSize.y,
            0);
        pPos[2] = nn::util::MakeFloat3(
            -1.f + (2.f * (pos.x + size.x)) / ScreenSize.x,
            1.f - (2.f * (pos.y + size.y)) / ScreenSize.y,
            0);
        pPos[3] = nn::util::MakeFloat3(
            -1.f + (2.f * (pos.x)) / ScreenSize.x,
            1.f - (2.f * (pos.y + size.y)) / ScreenSize.y,
            0);

        nn::util::Float4* pColor = static_cast<nn::util::Float4*>(mesh.GetVertexBufferCpuAddress(nns::gfx::PrimitiveRenderer::VertexAttribute_Color));
        for (size_t i = 0; i < 4; ++i)
        {
            pColor[i] = NN_UTIL_FLOAT_4_INITIALIZER(1.f, 1.f, 1.f, 1.f);
        }

        nn::util::Float4 uv = NN_UTIL_FLOAT_4_INITIALIZER
        (
            0.f, 0.f, 1.f, 1.f
        );

        nn::util::Float2* pUv = static_cast<nn::util::Float2*>(mesh.GetVertexBufferCpuAddress(nns::gfx::PrimitiveRenderer::VertexAttribute_Uv));
        pUv[0] = NN_UTIL_FLOAT_2_INITIALIZER(uv.x, uv.y);
        pUv[1] = NN_UTIL_FLOAT_2_INITIALIZER(uv.z, uv.y);
        pUv[2] = NN_UTIL_FLOAT_2_INITIALIZER(uv.z, uv.w);
        pUv[3] = NN_UTIL_FLOAT_2_INITIALIZER(uv.x, uv.w);

        pRenderer->SetColor(gDrawer.GetColor());

        pRenderer->DrawUserMesh(
            &(gGraphics.GetGraphicsSystem().GetCommandBuffer()),
            nn::gfx::PrimitiveTopology::PrimitiveTopology_TriangleList,
            &mesh,
            g_TextureDescriptor[0], g_SamplerDescriptor
        );
    }

    void DrawTitle() NN_NOEXCEPT
    {
        static nn::util::Float2 scale = NN_UTIL_FLOAT_2_INITIALIZER(1.f, 1.f);
        const auto& clearColor = gDrawer.GetClearColor();
        gDrawer.SetColor((clearColor.GetR() + clearColor.GetR() + clearColor.GetR()) / 3.f >= 128 ?
            nn::util::Color4u8(0, 33, 8, 255) :
            nn::util::Color4u8(192, 192, 192, 255));
        DrawTitleLogo(
            nn::util::MakeFloat2((420.f - 372.f * scale.x) / 2.f, 16.f + (128 - 100.f * scale.y) / 2.f),
            nn::util::MakeFloat2(372.f * scale.x, 100.f * scale.y));
    }

    void DrawIconSet(
        const nn::util::Float2& pos,
        const nn::util::Float2& scale,
        const TextureInfo& icon,
        const TextureKey& key) NN_NOEXCEPT
    {
        NN_ASSERT_GREATER(icon.size.x, 0);
        NN_ASSERT_GREATER(icon.size.y, 0);

        auto iconCountX = static_cast<int>(floor(icon.size.x / icon.divSize.x + 0.5f));
        auto iconCountY = static_cast<int>(floor(icon.size.y / icon.divSize.y + 0.5f));

        NN_ASSERT_GREATER(iconCountX, 0);
        NN_ASSERT_GREATER(iconCountY, 0);

        if (icon.iconSet.find(key) == icon.iconSet.end())
        {
            TT_LOG("# (warning) icon not found\n");
            return;
        }
        auto iconIndex = icon.iconSet.at(key);

        static const nn::util::Float2 ScreenSize = NN_UTIL_FLOAT_2_INITIALIZER(1280, 720);

        nns::gfx::PrimitiveRenderer::Renderer* pRenderer = &(gGraphics.GetGraphicsSystem().GetPrimitiveRenderer());
        nns::gfx::PrimitiveRenderer::PrimitiveMesh mesh;

        static const uint32_t index[6] =
        {
            0, 1, 2, 0, 2, 3
        };

        if (mesh.Initialize(pRenderer->GetGpuBuffer(), 4, 6,
            (nns::gfx::PrimitiveRenderer::VertexFormat)(nns::gfx::PrimitiveRenderer::VertexFormat_Pos | nns::gfx::PrimitiveRenderer::VertexFormat_Color | nns::gfx::PrimitiveRenderer::VertexFormat_Uv)) == false)
        {
            return;
        }

        uint32_t* pIndexData = mesh.GetIndexBufferCpuAddress();

        for (size_t i = 0; i < NN_ARRAY_SIZE(index); ++i)
        {
            pIndexData[i] = index[i];
        }

        nn::util::Float3* pPos = static_cast<nn::util::Float3*>(mesh.GetVertexBufferCpuAddress(nns::gfx::PrimitiveRenderer::VertexAttribute_Pos));
        pPos[0] = nn::util::MakeFloat3(
            -1.f + (2.f * (pos.x)) / ScreenSize.x,
            1.f - (2.f * (pos.y)) / ScreenSize.y,
            0);
        pPos[1] = nn::util::MakeFloat3(
            -1.f + (2.f * (pos.x + icon.divSize.x * scale.x)) / ScreenSize.x,
            1.f - (2.f * (pos.y)) / ScreenSize.y,
            0);
        pPos[2] = nn::util::MakeFloat3(
            -1.f + (2.f * (pos.x + icon.divSize.x * scale.x)) / ScreenSize.x,
            1.f - (2.f * (pos.y + icon.divSize.y * scale.y)) / ScreenSize.y,
            0);
        pPos[3] = nn::util::MakeFloat3(
            -1.f + (2.f * (pos.x)) / ScreenSize.x,
            1.f - (2.f * (pos.y + icon.divSize.y * scale.y)) / ScreenSize.y,
            0);


        nn::util::Color4u8 color[2];
        nn::util::Color4u8 primitiveColor;

        auto dir = gDrawer.GetColor(&color[0], &color[1]);
        nn::util::Float4* pColor = static_cast<nn::util::Float4*>(mesh.GetVertexBufferCpuAddress(nns::gfx::PrimitiveRenderer::VertexAttribute_Color));

        for (size_t idxFace = 0; idxFace < 4; idxFace++)
        {
            switch (dir)
            {
            case nns::hidfw::gfx::GraphicsDrawer::GradationDirection_None:
                primitiveColor = color[0];
                break;
            case nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Left:
                primitiveColor = (1.f - ((pPos[idxFace].x + 1.f) * (ScreenSize.x / 2.f) - pos.x) / (icon.divSize.x * scale.x) > 0.5f) ? color[1] : color[0];
                break;
            case nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up:
                primitiveColor = (1.f - ((1.f - pPos[idxFace].y) * (ScreenSize.y / 2.f) - pos.y) / (icon.divSize.y * scale.y) > 0.5f) ? color[1] : color[0];
                break;
            case nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Right:
                primitiveColor = ((((pPos[idxFace].x + 1.f) * (ScreenSize.x / 2.f)) - pos.x) / (icon.divSize.x * scale.x) > 0.5f) ? color[1] : color[0];
                break;
            case nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down:
                primitiveColor = (((1.f - pPos[idxFace].y) * (ScreenSize.y / 2.f) - pos.y) / (icon.divSize.y * scale.y) > 0.5f) ? color[1] : color[0];
                break;
            default:
                NN_UNEXPECTED_DEFAULT;
            }
            for (size_t i = 0; i < NN_ARRAY_SIZE(primitiveColor.v); ++i)
            {
                pColor[idxFace].v[i] = static_cast<float>(primitiveColor.v[i]) / 255.f;
            }
        }
        pRenderer->SetColor(nn::util::Color4u8::White());

        nn::util::Float4 uv = NN_UTIL_FLOAT_4_INITIALIZER
        (
            static_cast<float>(iconIndex % iconCountX) * icon.divSize.x / icon.size.x,
            static_cast<float>(iconIndex / iconCountX) * icon.divSize.y / icon.size.y,
            (static_cast<float>(iconIndex % iconCountX) + 1.f) * icon.divSize.x / icon.size.x,
            (static_cast<float>(iconIndex / iconCountX) + 1.f) * icon.divSize.y / icon.size.y
        );

        nn::util::Float2* pUv = static_cast<nn::util::Float2*>(mesh.GetVertexBufferCpuAddress(nns::gfx::PrimitiveRenderer::VertexAttribute_Uv));
        pUv[0] = NN_UTIL_FLOAT_2_INITIALIZER(uv.x, uv.y);
        pUv[1] = NN_UTIL_FLOAT_2_INITIALIZER(uv.z, uv.y);
        pUv[2] = NN_UTIL_FLOAT_2_INITIALIZER(uv.z, uv.w);
        pUv[3] = NN_UTIL_FLOAT_2_INITIALIZER(uv.x, uv.w);

        pRenderer->DrawUserMesh(
            &(gGraphics.GetGraphicsSystem().GetCommandBuffer()),
            nn::gfx::PrimitiveTopology::PrimitiveTopology_TriangleList,
            &mesh,
            g_TextureDescriptor[icon.textureIndex], g_SamplerDescriptor
        );
    }

    void DrawNpadStyle(
        const nn::util::Float2& pos,
        const nn::util::Float2& scale,
        const nn::hid::NpadStyleSet& style,
        const StyleIconType type) NN_NOEXCEPT
    {
        NN_ASSERT_LESS_EQUAL(style.CountPopulation(), 1);
        IconIndex index = 0;
        for (index = 0; index < style.GetCount() && !style.Test(index); ++index) {}
        DrawIconSet(pos, scale, g_NpadStyleIconSet, TextureKey::Make(index, type));
    }

    void DrawNpadButton(
        const nn::util::Float2& pos,
        const nn::util::Float2& scale,
        const nn::hid::NpadButtonSet& button,
        const ButtonIconType type) NN_NOEXCEPT
    {
        NN_ASSERT_LESS_EQUAL(button.CountPopulation(), 1);
        IconIndex index = 0;
        for (index = 0; index < button.GetCount() && !button.Test(index); ++index) {}
        DrawIconSet(pos, scale, g_NpadButtonIconSet, TextureKey::Make(index, type));
    }

    void DrawToolIcon(
        const nn::util::Float2& pos,
        const nn::util::Float2& scale,
        const ToolIconSet& icon) NN_NOEXCEPT
    {
        NN_ASSERT_LESS_EQUAL(icon.CountPopulation(), 1);
        IconIndex index = 0;
        for (index = 0; index < icon.GetCount() && !icon.Test(index); ++index) {}
        DrawIconSet(pos, scale, g_ToolIconSet, TextureKey::Make(index, 0));
    }
}
