﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <nn/hid/hid_ControllerSupport.h>

#include "Base.h"
#include "Drawer.h"
#include "File.h"
#include "Vibration.h"
#include "ExportDialog.h"
#include "SettingDialog.h"

namespace VibrationCollection
{
    enum ApplicationButtonGroup
    {
        ApplicationButtonGroup_Main = 0,        //!< 設定の開閉、振動の再生ボタン
        ApplicationButtonGroup_File = 1,        //!< ファイルオープン/リロード に使用
        ApplicationButtonGroup_Vibration,       //!< 振動ファイル
        ApplicationButtonGroup_Audio,           //!< 効果音ファイル
        ApplicationButtonGroup_Num              //!< アプリケーションのボタングループ数
    };

    extern nns::hidfw::layout::ButtonGroup g_ButtonGroup[ApplicationButtonGroup_Num];
    extern nns::hidfw::layout::ButtonGroup g_CloseButton;

    extern int g_ButtonCount;
    extern int g_BnvibButtonStartIndex;
    extern int g_AudioButtonStartIndex;
    extern int g_SelectedBnvibButtonInedx;
    extern int g_SelectedAudioButtonIndex;

    void InitializeMainButtonGroup(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeFileButtonGroup(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeVibrationButtonGroup(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeAudioButtonGroup(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void InitializeVibrationViewer(nns::hidfw::layout::ButtonGroup* pButtonGroup) NN_NOEXCEPT;

    void DirectorySelectButton(void* pushButton, void* param) NN_NOEXCEPT;

    void ReloadButton(void* pushButton, void* param) NN_NOEXCEPT;

    void PlayVibrationButton(void* pushButton, void* param) NN_NOEXCEPT;

    void SelectAudioFile(void* pushButton, void* param) NN_NOEXCEPT;

    void CloseButtonFunc(void* pushButton, void* param) NN_NOEXCEPT;
}
