﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>

#include <nn/fs.h>
#include <nn/os.h>

#include "Config.h"
#include "Json.h"

namespace nns { namespace hid { namespace util {

/**
 * @brief   文字列リソースを扱うクラス
 */
class StringTable final
{
    NN_DISALLOW_COPY(StringTable);
    NN_DISALLOW_MOVE(StringTable);

public:
    static StringTable& GetInstance() NN_NOEXCEPT
    {
        NN_FUNCTION_LOCAL_STATIC(StringTable, s_Instance);
        return s_Instance;
    }

public:
    /**
     * @brief   文字列リソースを読み込む
     */
    JsonResult Open(const char* filename) NN_NOEXCEPT;

    void Close() NN_NOEXCEPT;

    /**
     * @brief   使用する言語を設定
     */
    void SetLanguage(Language lang) NN_NOEXCEPT
    {
        m_Language = lang;
    }

    /**
     * @brief   指定したキーに対応する文字列を取得
     */
    const char* Get(const char* key) NN_NOEXCEPT;

private:
    StringTable() NN_NOEXCEPT
        : m_Json()
    {}

    ~StringTable()
    {
        Close();
    }

    const char* GetLanguageKey() const NN_NOEXCEPT
    {
        return (m_Language == Language::Japanese) ? "ja" : "en";
    }

private:
    JsonDocument    m_Json;
    Language        m_Language;
};

}}}  // nns::hid::util
