﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>

#include <nn/nn_Macro.h>
#include <nn/fs.h>
#include <nn/os.h>

#define RAPIDJSON_NO_INT64DEFINE
#define RAPIDJSON_NAMESPACE             nne::rapidjson
#define RAPIDJSON_NAMESPACE_BEGIN       namespace nne { namespace rapidjson {
#define RAPIDJSON_NAMESPACE_END         }}
#define RAPIDJSON_ASSERT(x)             NN_SDK_ASSERT(x)
#define RAPIDJSON_HAS_CXX11_RVALUE_REFS 1 // NOLINT(readability/define)
#define RAPIDJSON_HAS_CXX11_TYPETRAITS  1 // NOLINT(readability/define)

// Windows 環境での警告抑止用
#if defined(NN_BUILD_CONFIG_OS_WIN32)
#pragma warning(push)
#pragma warning(disable : 4244)
#pragma warning(disable : 4668)
#pragma warning(disable : 4702)
#endif
#include <rapidjson/rapidjson.h>
#include <rapidjson/document.h>
#include <rapidjson/stringbuffer.h>
#if defined(NN_BUILD_CONFIG_OS_WIN32)
#pragma warning(pop)
#endif

namespace nns { namespace hid { namespace util {

enum class JsonResult
{
    Success,
    ReadFailed
};

class JsonDocument final
{
    NN_DISALLOW_COPY(JsonDocument);
    NN_DISALLOW_MOVE(JsonDocument);

public:
    JsonDocument() NN_NOEXCEPT;

    ~JsonDocument() NN_NOEXCEPT;

    bool IsOpened() const NN_NOEXCEPT
    {
        std::lock_guard<decltype(m_Mutex)> lock(m_Mutex);

        return m_ReadBuffer != nullptr;
    }

    JsonResult Open(const char* jsonfile) NN_NOEXCEPT;

    void Close() NN_NOEXCEPT;

    nne::rapidjson::Document& GetDocument() NN_NOEXCEPT
    {
        NN_ASSERT(IsOpened());

        return m_JsonDocument;
    }

private:
    nn::Result OpenImpl(const char* jsonfile) NN_NOEXCEPT;

    bool Parse() NN_NOEXCEPT;

private:
    mutable nn::os::Mutex       m_Mutex;

    nn::fs::FileHandle          m_FileHandle;
    int64_t                     m_FileSize;
    char*                       m_ReadBuffer;
    nne::rapidjson::Document    m_JsonDocument;
};

}}}  // nns::hid::util
