﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/hid/system/hid_UniquePad.h>

#include "../sgx/gui/SimpleGfx_Gui.h"
#include "../util/FirmwareImage.h"
#include "../util/UniquePadManager.h"

namespace nns { namespace hid { namespace ui {

/**
 * @brief   UniquePad の情報を表示するボタンを扱うクラスです。
 */
class UniquePadButton final :
    public nns::sgx::gui::Button
{
    NN_DISALLOW_COPY(UniquePadButton);
    NN_DISALLOW_MOVE(UniquePadButton);

public:
    UniquePadButton() NN_NOEXCEPT;

    /**
     * @brief   UniquePadManager を設定します。
     */
    void SetManager(util::UniquePadManager* pManager) NN_NOEXCEPT;

    /**
     * @brief   割り当てられている UniquePadId を取得します。
     */
    nn::hid::system::UniquePadId GetUniquePadId() const NN_NOEXCEPT
    {
        return m_Id;
    }

    /**
     * @brief   UniquePadId を割り当てます。
     */
    void SetUniquePadId(const nn::hid::system::UniquePadId& id, int index) NN_NOEXCEPT;

    /**
     * @brief   書き込み対象のデバイスタイプを設定します。
     */
    void SetTargetDevice(util::DeviceTypeSet deviceType) NN_NOEXCEPT;

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

private:
    virtual void RenderContents() NN_NOEXCEPT NN_OVERRIDE;

private:
    util::UniquePadManager*         m_pManager;             //!< UniquePad 管理クラス
    nn::hid::system::UniquePadId    m_Id;                   //!< 割り当てられた UniquePadId
    int                             m_Index;                //!< ボタン番号
    util::DeviceTypeSet             m_TargetDeviceType;     //!< 書き込み対象のデバイスタイプ
};

}}}  // nns::hid::ui
