﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "../sgx/gui/SimpleGfx_Gui.h"
#include "../util/FirmwareImage.h"

namespace nns { namespace hid { namespace ui {

/**
 * @brief   ファームウェアイメージを表示するボタンを扱うクラスです。
 */
class FirmwareImageButton final :
    public nns::sgx::gui::Button
{
    NN_DISALLOW_COPY(FirmwareImageButton);
    NN_DISALLOW_MOVE(FirmwareImageButton);

public:
    FirmwareImageButton() NN_NOEXCEPT;

    bool IsValid() const NN_NOEXCEPT
    {
        return m_pImage != nullptr;
    }

    void SetImage(const util::FirmwareImage* pImage) NN_NOEXCEPT;

private:
    virtual void RenderContents() NN_NOEXCEPT NN_OVERRIDE;

private:
    const util::FirmwareImage*  m_pImage;
};

}}}  // nns::hid::ui
