﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       画面レイアウト作成、更新のための API の宣言
 */

#pragma once

#include "hid.h"
#include "gfx.h"
#include "layout/layout_Button.h"
#include "layout/layout_ButtonGroup.h"
#include "layout/layout_SeekBar.h"
#include "layout/layout_LineChart.h"
#include "layout/layout_BarChart.h"
#include "layout/layout_Dialog.h"

namespace nns { namespace hidfw { namespace layout {

    /**
     * @brief       画面レイアウトを総合的に利用するする為のクラスです
     */
    class Layout
    {
        NN_DISALLOW_COPY(Layout);
        NN_DISALLOW_MOVE(Layout);

    public:
        //----------------------------------------------------------------
        //! @brief インスタンスの取得
        //----------------------------------------------------------------
        static Layout& GetInstance() NN_NOEXCEPT;

        //----------------------------------------------------------------
        //! @brief  更新処理
        //! details libnnf_hid を利用する場合、本関数は
        //!         gInput.Update() の呼び出しよりも後に呼び出して下さい
        //----------------------------------------------------------------
        void Update() NN_NOEXCEPT;

        //----------------------------------------------------------------
        //! @brief 描画処理
        //! details 本関数は gDrawer.BeginDraw()～ gDrawer.EndDraw() の間で呼び出す必要があります
        //----------------------------------------------------------------
        void Draw() NN_NOEXCEPT;

        //----------------------------------------------------------------
        //! @brief 初期化処理
        //----------------------------------------------------------------
        void Initialize() NN_NOEXCEPT;

        //----------------------------------------------------------------
        //! @brief 終了処理
        //----------------------------------------------------------------
        void Finalize() NN_NOEXCEPT;


    private:
        //----------------------------------------------------------------
        //! @brief GetInstance の内部で呼び出されます
        //----------------------------------------------------------------
        Layout() NN_NOEXCEPT;
    };

}}}

#define gLayout (nns::hidfw::hid::Layout::GetInstance())
