﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
  Npad 機能のサンプルです
*/

#include "hidFw/gfx.h"
#include "hidFw/hid.h"

void DrawController(const nn::util::Float2& pos, const size_t stateCount, nns::hidfw::hid::Controller::ControllerState* pState, nn::hid::SixAxisSensorState* pLeft, nn::hid::SixAxisSensorState* pRight);

namespace InputSample
{
    extern "C" void nnMain()
    {
        uint64_t frameCount = 0;
        gInput.Initialize();                                    // コントローラとタッチスクリーンの初期化を行います
        gInput.SetLoggingTarget(
            nns::hidfw::hid::Input::KeyLoggerTarget::Style::Mask |
            nns::hidfw::hid::Input::KeyLoggerTarget::ButtonSet::Mask |
            nns::hidfw::hid::Input::KeyLoggerTarget::AnalogStick::Mask |
            nns::hidfw::hid::Input::KeyLoggerTarget::SixAxisSensor::Mask |
            nns::hidfw::hid::Input::KeyLoggerTarget::HoldType::Mask |
            nns::hidfw::hid::Input::KeyLoggerTarget::HandheldActivationMode::Mask
        );
        //gInput.StartKeyLoggerHost("C:/Windows/Temp");         // キー入力を監視し、C:/Windows/Temp に出力します。

        gGraphics.Initialize();                                 // グラフィックスの初期化を行います
        gGraphics.GetGraphicsSystem().SetEnablePerfMeter(true); // パフォーマンスを表示します

        nns::hidfw::hid::Controller::ControllerState   state[16];
        nn::hid::SixAxisSensorState             leftSixAxisSensorState[16];
        nn::hid::SixAxisSensorState             rightSixAxisSensorState[16];

        //======================================================================
        // メインループ
        //======================================================================
        bool exit = false;
        do
        {
            gGraphics.GetGraphicsSystem().BeginPerfFrame();
            //======================================================================
            // 入力処理
            //======================================================================
            gInput.Update();                // コントローラとタッチスクリーンの更新を行います

            size_t stateCount = 0;

            // 全てのNpadId::No1 ～ Handheld までのコントローラの
            for (std::vector<nns::hidfw::hid::Controller*>::iterator it = gController.GetControllerList().begin();
                it != gController.GetControllerList().end();
                ++it)
            {
                // ボタン入力
                if ((*it)->IsHold(nn::hid::NpadButton::L::Mask))
                {
                    (*it)->GetVibration().SendLeft(nn::hid::VibrationValue::Make(0.0f, 160.f, 0.2f, 330.f));
                }
                if ((*it)->IsHold(nn::hid::NpadButton::R::Mask))
                {
                    (*it)->GetVibration().SendRight(nn::hid::VibrationValue::Make(0.2f, 160.f, 0.0f, 330.f));
                }
                if ((*it)->IsHold(nn::hid::NpadButton::ZL::Mask))
                {
                    gInput.StartKeyLogger(nns::hidfw::hid::Input::KeyLoggerOutputMode::KeyLoggerOutputMode_TargetManager); // TargetManager にキー入力のログを出力します
                }
                if ((*it)->IsHold(nn::hid::NpadButton::ZR::Mask))
                {
                    gInput.StopKeyLogger();                                                                         // ログ出力を停止します
                }
                if ((*it)->IsTrigger(nn::hid::NpadButton::X::Mask))
                {
                    (*it)->StartSixAxisSensor();
                }
                if ((*it)->IsTrigger(nn::hid::NpadButton::Y::Mask))
                {
                    (*it)->StopSixAxisSensor();
                }
                if (((*it)->GetHldButton() & (nn::hid::NpadButton::Plus::Mask | nn::hid::NpadButton::Minus::Mask)).CountPopulation() == 2)
                {
                    exit = true;
                }

                // ステータスの取得
                nn::hid::SixAxisSensorState sixAxisSensor[2];
                state[(it - gController.GetControllerList().begin())] = (*it)->GetState();          // コントローラのステータス
                size_t sixAxisSensorStateCount = (*it)->GetSixAxisSensorState(2, sixAxisSensor);    // 6軸センサ

                leftSixAxisSensorState[(it - gController.GetControllerList().begin())] = (sixAxisSensorStateCount >= 1) ? sixAxisSensor[0] : nn::hid::SixAxisSensorState();
                rightSixAxisSensorState[(it - gController.GetControllerList().begin())] = (sixAxisSensorStateCount >= 2) ? sixAxisSensor[1] : nn::hid::SixAxisSensorState();

                if (++stateCount >= NN_ARRAY_SIZE(state))
                {
                    // あらかじめ用意していた配列のサイズを超過した場合はループから抜ける
                    break;
                }
            }

            //======================================================================
            // 描画処理
            //======================================================================
            gDrawer.BeginDraw();            // 描画関数の受付開始
            {
                DrawController(nn::util::MakeFloat2(32.f, 32.f), stateCount, state, leftSixAxisSensorState, rightSixAxisSensorState);
            }
            gDrawer.EndDraw();              // 描画終了
            ++frameCount;
            gGraphics.GetGraphicsSystem().EndPerfFrame();
        } while (!exit);                    // プラスマイナス同時押しで終了します

        gInput.Finalize();
        gGraphics.Finalize();               // 確保していたリソースを開放します

    }
}

void DrawController(const nn::util::Float2& pos, const size_t stateCount, nns::hidfw::hid::Controller::ControllerState* pState, nn::hid::SixAxisSensorState* pLeft, nn::hid::SixAxisSensorState* pRight)
{
    gTextWriter.SetCursor(pos.x, pos.y);
    for (size_t i = 0; i < stateCount; ++i)
    {
        gTextWriter.SetCursorX(pos.x);

        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::A>() ? "A" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::B>() ? "B" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::X>() ? "X" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::Y>() ? "Y" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::StickL>() ? "Ls" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::StickR>() ? "Rs" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::L>() ? "L" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::R>() ? "R" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::ZL>() ? "ZL" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::ZR>() ? "ZR" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::Plus>() ? "+" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::Minus>() ? "-" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::Left>() ? "<" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::Up>() ? "^" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::Right>() ? ">" : "_");
        gTextWriter.Print("%s", pState[i].buttons.Test<nn::hid::NpadButton::Down>() ? "v" : "_");

        gTextWriter.Print(" StickL(%05d, %05d)", pState[i].analogStickL.x, pState[i].analogStickL.y);
        gTextWriter.Print(" StickR(%05d, %05d)", pState[i].analogStickR.x, pState[i].analogStickR.y);

        gTextWriter.Print(" SixAxis1(%5.4f, %5.4f, %5.4f)", pLeft[i].acceleration.x, pLeft[i].acceleration.y, pLeft[i].acceleration.z);
        gTextWriter.Print(" SixAxis2(%5.4f, %5.4f, %5.4f)", pRight[i].acceleration.x, pRight[i].acceleration.y, pRight[i].acceleration.z);

        gTextWriter.Print("\n");
    }
}
