﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include "DevQuestMenu_ModeSceneCommon.h"

namespace nn { namespace devquestmenu {

    /**
     * @brief       スリープモード
     *
     */
    class SleepModeScene : public ModeSceneCommon
    {
    public:
        explicit SleepModeScene(RootSurfaceContext* pRootSurface) NN_NOEXCEPT;

        void OnLoop() NN_NOEXCEPT NN_OVERRIDE;

        ModeType DetermineNextMode(const DisplayModeTime& displayModeTime) NN_NOEXCEPT NN_OVERRIDE;

        ModeType GetSuccessNextMode() NN_NOEXCEPT NN_OVERRIDE;

    private:

        void SleepWithWakeUpTimer() NN_NOEXCEPT;

        bool m_IsSleepFinished = false;
    };
}}
