﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include <nn/aoc.h>
#include <nn/ns/ns_ApplicationRecordApi.h>
#include <nn/rid.h>
#include "../DevQuestMenu_AssetMeta.h"
#include "../DevQuestMenu_PowerSupplyChecker.h"
#include "../DevQuestMenu_TextureView.h"
#include "DevQuestMenu_ModeSceneCommon.h"

namespace nn { namespace devquestmenu {

    /**
     * @brief       試遊モード
     *
     */
    class DisplayModeScene : public ModeSceneCommon
    {
    public:
        explicit DisplayModeScene(RootSurfaceContext* pRootSurface) NN_NOEXCEPT;

        ~DisplayModeScene() NN_NOEXCEPT;

        void OnLoop() NN_NOEXCEPT NN_OVERRIDE;

        /**
         * @brief       本体更新モードに遷移できるかを判定します
         *
         * @param[in]   displayModeTime     更新開始時間の設定
         *
         * @detail      バッテリーが残量が 25% 以下かつ給電されていないの場合、スリープさせます
         *              displayModeTime で定義された更新時間に入ったら、本体更新モードに遷移します
         */
        ModeType DetermineNextMode(const DisplayModeTime& displayModeTime) NN_NOEXCEPT NN_OVERRIDE;

        ModeType GetSuccessNextMode() NN_NOEXCEPT NN_OVERRIDE;

        /**
         * @brief       アプリケーションジャンプを行うボタンをリスト状に列挙します。
         *
         */
        void RegisterDebugButton(glv::ViewContainer* pContainer) NN_NOEXCEPT NN_OVERRIDE;

    private:

        bool UpdateAocListSaveData(nn::aoc::AddOnContentIndex* pOutAocBuffer, int* pOutAocCount) NN_NOEXCEPT;
        bool UpdateApplicationListSaveData(nn::ncm::ApplicationId* pOutApplicationBuffer, int* pOutApplicationCount) NN_NOEXCEPT;
        bool UpdateSaveData(const char* key, const std::vector<std::string>& idList, int count, const char* savedataName) NN_NOEXCEPT;

        /**
         * @brief       本体にインストールされている Aoc 情報を初期化します
         *
         */
        void InitializeAssetMetaList(const nn::aoc::AddOnContentIndex* pAocListBuffer, int aocCount) NN_NOEXCEPT;

        int m_InstalledAocCount;                                            //! インストールされている AOC の数
        bool m_IsLaunchDelayed;                                    //! アプリケーションジャンプを 40 秒遅延させる。
        bool m_IsSleepRequiredForPowerSupply;                       //! Sleep させるべき電源供給量か
        std::unique_ptr<PowerSupplyChecker> m_pPowerSupplyChecker;  //! 電源監視機能

        const glv::Rect m_AocButtonRect = { m_GridWidth * 5, m_GridHeight, m_GridWidth * 6, m_GridHeight * 2 };
        const glv::Rect m_TextureRect = { m_GridWidth * 11, m_GridHeight, m_GridWidth * 5, m_GridHeight * 13 };

        std::unique_ptr<TextureView> m_SelectedAocIcon;                     //! 選択されている AOC のアイコン
        std::unique_ptr<LabelButton> m_DelayLaunchButton;                   //! アプリケーションジャンプ遅延ボタン
        std::unique_ptr<LabelButton> m_AccessExceptionButton;               //! アクセス例外でのメニュークラッシュボタン
        std::unique_ptr<LabelButton> m_MenuAbortButton;                     //! Abort でのメニュークラッシュボタン
        std::vector<std::unique_ptr<AssetMeta>> m_AssetMetaContainer;       //! AssetMeta のコンテナ
        std::vector<std::unique_ptr<LabelButton>> m_LabelButtonContainer;   //! LabelButton のコンテナ
        std::unique_ptr<glv::ViewContainer> m_DisplayModeDebugTab;          //! DisplayMode のデバッグタブ
    };
}}
