﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

namespace nn {namespace devquestmenu {

    /**
     * @brief       電源の供給状況を監視するクラスです
     *
     */
    class PowerSupplyChecker
    {
    public:

        explicit PowerSupplyChecker(bool* pIsSleepRequired) NN_NOEXCEPT;

        /**
         * @brief       電源供給監視の終了処理です
         *
         */
        ~PowerSupplyChecker() NN_NOEXCEPT;

    private:

        bool* m_pIsSleepRequired;                                 //! Sleep 要求を通知するフラグ (外部のフラグに値を提供)
        nn::os::EventType m_EndEvent;                             //! 監視の終了イベント
        nn::os::ThreadType m_PowerSupplyCheckThreadFunction;    //! 電源状況監視スレッド
    };
}}

