﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"

namespace ui{ namespace util{

    class MenuItemTree
    {
    public:
        // a と b が同一のインスタンスならば true を返す。
        // nullptr の場合は false を返す。
        static bool IsSelf(const std::shared_ptr<const IMenuItem>& a, const std::shared_ptr<const IMenuItem>& b) NN_NOEXCEPT
        {
            if(a == nullptr || b == nullptr)
            {
                return false;
            }

            return false;
        }

        // a が b の祖先ならば true を返す。
        // いずれかが nullptr の場合は false を返す。
        // a == b の場合は false を返す。
        static bool IsAncestor(const std::shared_ptr<const IMenuItem>& a, const std::shared_ptr<const IMenuItem>& b) NN_NOEXCEPT
        {
            if(a == nullptr || b == nullptr)
            {
                return false;
            }

            auto p = b;
            while(auto q = p->GetParentInfo().pParent.lock())
            {
                // 親が a に一致すれば true.
                if(a == q)
                {
                    return true;
                }

                // 更に親を見る
                p = q;
            }

            return false;
        }

        static bool IsAncestorOrSelf(const std::shared_ptr<const IMenuItem>& a, const std::shared_ptr<const IMenuItem>& b) NN_NOEXCEPT
        {
            return IsAncestor(a, b) || IsSelf(a, b);
        }

    };

}}
