﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"
#include "ui_MenuItemGeometry.h"

namespace ui{ namespace util{

    class FindTouchAcceptingItem
    {
    private:
        struct Context
        {
            std::shared_ptr<IMenuItem> pCandidate;

            Position position;
        };

    public:
        static std::shared_ptr<IMenuItem> Find(const std::shared_ptr<IMenuItem>& pItem, const nn::util::Vector3f& position) NN_NOEXCEPT
        {
            if(!pItem)
            {
                return nullptr;
            }

            Context context = { nullptr, {static_cast<int>(position.GetX()), static_cast<int>(position.GetY())} };
            auto crop = Aabb::FromRectangle(MenuItemGeometry::GetGlobalRectangle(pItem));

            FindImpl(pItem, context, crop);
            return context.pCandidate;
        }

    private:
        static void FindImpl(const std::shared_ptr<IMenuItem>& pTarget, Context& context, const Aabb& crop) NN_NOEXCEPT
        {
            if(!pTarget)
            {
                return;
            }

            // 無効なアイテムは無視する
            if(!pTarget->IsEnabled())
            {
                return;
            }

            // 表示領域がない場合無視する
            auto scrop = crop.Intersect(Aabb::FromRectangle(MenuItemGeometry::GetGlobalRectangle(pTarget)));
            if(scrop.IsEmpty())
            {
                return;
            }

            if(pTarget->IsTouchAcceptable())
            {
                if(scrop.Contains(context.position))
                {
                    context.pCandidate = pTarget;
                }
            }

            int n = pTarget->GetChildCount();
            for(int i = 0; i < n; i++)
            {
                FindImpl(pTarget->GetChild(i), context, scrop);
            }
        }

    };

}}
