﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_StyleTypes.h"

namespace ui{ namespace util{

    class CalculateItemSize
    {
    public:
        // SizeStyle に応じたアイテムの大きさを計算する。
        // 固定サイズなら Size の値。
        // 可変サイズなら contentSizeGetterFunction または Size の大きい方の値。
        //
        // サイズに上限を設定する場合はスクロールできるようにしないといけないので
        // InnerFrame 的なものを実装して対応するべきな気がする。
        template<typename F>
        static Size Calculate(F contentSizeGetterFunction, const SizeStyle& style) NN_NOEXCEPT
        {
            if(style.GetMode() == SizeMode_Fixed)
            {
                return style.GetSize();
            }
            else
            {
                auto size = contentSizeGetterFunction();
                auto sizeMin = style.GetSize();

                size.width  = std::max(size.width , 0);
                size.height = std::max(size.height, 0);

                if(sizeMin.width >= 0)
                {
                    size.width = std::max(size.width, sizeMin.width);
                }

                if(sizeMin.height >= 0)
                {
                    size.height = std::max(size.height, sizeMin.height);
                }

                return size;
            }
        }


    };

}}
