﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_Types.h"
#include "../ui_ItemAlignment.h"

namespace ui{ namespace util{

    class CalculateAlignedPosition
    {
    public:
        static Position Calculate(const Size& innerSize, const Size& outerSize, ItemAlignment alignment) NN_NOEXCEPT
        {
            int posX;
            switch(alignment & ui::ItemAlignment_HorizontalMask)
            {
            case ui::ItemAlignment_Right:
                posX = outerSize.width - innerSize.width;
                break;
            case ui::ItemAlignment_Center:
                posX = (outerSize.width - innerSize.width) / 2;
                break;
            default:
                // ui::ItemAlignment_Left
                posX = 0;
            }

            int posY;
            switch(alignment & ui::ItemAlignment_VerticalMask)
            {
            case ui::ItemAlignment_Bottom:
                posY = outerSize.height - innerSize.height;
                break;
            case ui::ItemAlignment_Middle:
                posY = (outerSize.height - innerSize.height) / 2;
                break;
            default:
                // ui::ItemAlignment_Top
                posY = 0;
            }

            return {posX, posY};
        }

    };

}}
