﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "base/ui_MenuItemBase.h"
#include "base/ui_MenuItemBoxBase.h"
#include "base/ui_MenuItemStyleProperty.h"

namespace ui{

    class MenuItemTableCellStyle
        : public
            base::MenuItemStylePropertySizeStyle<base::StateNone,
            base::MenuItemStylePropertyAlignment<base::StateNone,
            base::MenuItemStylePropertyBackgroundStyle<base::StateNone,
            base::MenuItemStylePropertyMargin<base::StateNone,
            base::MenuItemStyleBase<MenuItemTableCellStyle>
            >>>>
    {};

    class MenuItemTableCell
        : public  base::MenuItemBoxBase
                < base::MenuItemBase<IMenuItem, MenuItemTableCell>
                >
    {
    public:
        explicit MenuItemTableCell(const MenuItemTableCellStyle& style) NN_NOEXCEPT;

        virtual bool IsTouchAcceptable() const NN_NOEXCEPT UI_FINAL { return false; }
        virtual BackgroundStyle GetCurrentBackgroundStyle() const NN_NOEXCEPT UI_FINAL { return this->m_Style.GetBackgroundStyle(); }
        virtual SizeStyle       GetCurrentSizeStyle()       const NN_NOEXCEPT UI_FINAL { return this->m_Style.GetSizeStyle(); }
        virtual Margin          GetCurrentMargin()          const NN_NOEXCEPT UI_FINAL { return this->m_Style.GetMargin(); }
        virtual ItemAlignment   GetCurrentAlignment()       const NN_NOEXCEPT UI_FINAL { return this->m_Style.GetAlignment(); }

    private:
        MenuItemTableCellStyle m_Style = {};
    };


}
