﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace ui{

    enum ItemAlignment : uint16_t
    {
        ItemAlignment_HorizontalMask = 0x00FF,
        ItemAlignment_VerticalMask   = 0xFF00,

        ItemAlignment_Left           = 0x0000,
        ItemAlignment_Center         = 0x0001,
        ItemAlignment_Right          = 0x0002,
        ItemAlignment_Top            = 0x0000,
        ItemAlignment_Middle         = 0x0100,
        ItemAlignment_Bottom         = 0x0200,

        ItemAlignment_TopLeft      = 0x0000,
        ItemAlignment_TopCenter    = 0x0001,
        ItemAlignment_TopRight     = 0x0002,
        ItemAlignment_MiddleLeft   = 0x0100,
        ItemAlignment_MiddleCenter = 0x0101,
        ItemAlignment_MiddleRight  = 0x0102,
        ItemAlignment_BottomLeft   = 0x0200,
        ItemAlignment_BottomCenter = 0x0201,
        ItemAlignment_BottomRight  = 0x0202,
    };

}
