﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include "INotification.h"
#include "../../panel/panel_PanelContainer.h"

namespace scene{ namespace overlay{

    class NotificationSlot
    {
    public:
        NotificationSlot() NN_NOEXCEPT;
        ~NotificationSlot() NN_NOEXCEPT;

        // スロットに通知が設定されているかを返します。
        bool HasNotification() const NN_NOEXCEPT;

        // スロットの表示位置を設定します。
        void SetNotificationSlotIndex(int value) NN_NOEXCEPT;

        // スロットに設定されている通知をクリアします。
        void ResetNotification() NN_NOEXCEPT;

        // スロットに新しく通知を設定します。
        // 既に通知が設定されている場合、上書き可能かの判定が行われ、上書き可能な場合設定されます。
        bool SetNotification(const std::shared_ptr<INotification>& pNotification, nn::os::Tick startTick, nn::os::MultiWaitType* pMultiWait) NN_NOEXCEPT;

        // 設定中の通知の表示時間が経過したかを検査します。
        // 表示時間を経過している場合、このスロットから除外されます。
        void CheckExpired(nn::os::Tick currentTick) NN_NOEXCEPT;

        // 描画用パネルを更新します。
        void UpdatePanel() NN_NOEXCEPT;

        // 描画用パネルを取得します。
        std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT;

    private:
        std::shared_ptr<panel::PanelContainer> m_pPanelContainer;
        std::shared_ptr<INotification> m_pNotification;

        nn::os::TimerEventType      m_ExpiringEvent;
        nn::os::MultiWaitHolderType m_ExpiringEventHolder;
        bool                        m_IsExpiringEventLinked;
    };

}}
