﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationMovie.h"

#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    namespace {
        enum Priority
        {
            Priority_Highest = 0,
            Priority_ResultError,
            Priority_ResultSuccess,
            Priority_Progress,
            Priority_Lowest,
        };
    }

    NotificationMovie::NotificationMovie() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetMovieTextColor());
        m_pPanel->SetTextPosition(Style::GetMovieTextPositionX(), Style::GetMovieTextPositionY());
        m_pPanel->SetTextSize(Style::GetMovieTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationMovie::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationMovie::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationMovie::SetupStarted() NN_NOEXCEPT
    {
        m_pPanel->SetText("Movie ...");

        m_TimeToLive = config::NotificationTtl::GetTtlMovieSaving();
        m_Category   = NotificationCategory_Movie;
        m_Priority   = Priority_Progress;
        return true;
    }

    bool NotificationMovie::SetupSuccess() NN_NOEXCEPT
    {
        m_pPanel->SetText("Movie ... Saved");

        m_TimeToLive = config::NotificationTtl::GetTtlMovieSuccess();
        m_Category   = NotificationCategory_Movie;
        m_Priority   = Priority_ResultSuccess;
        return true;
    }

    bool NotificationMovie::SetupNotEnabled() NN_NOEXCEPT
    {
        m_pPanel->SetText("Movie ... Disabled");

        m_TimeToLive = config::NotificationTtl::GetTtlMovieFailure();
        m_Category   = NotificationCategory_Movie;
        m_Priority   = Priority_ResultError;
        return true;
    }

    bool NotificationMovie::SetupNotPermitted() NN_NOEXCEPT
    {
        m_pPanel->SetText("Movie ... Prohibited");

        m_TimeToLive = config::NotificationTtl::GetTtlMovieFailure();
        m_Category   = NotificationCategory_Movie;
        m_Priority   = Priority_ResultError;
        return true;
    }

    bool NotificationMovie::SetupError() NN_NOEXCEPT
    {
        m_pPanel->SetText("Movie ... Error");

        m_TimeToLive = config::NotificationTtl::GetTtlMovieFailure();
        m_Category   = NotificationCategory_Movie;
        m_Priority   = Priority_ResultError;
        return true;
    }

    bool NotificationMovie::SetupAlbumIsFull() NN_NOEXCEPT
    {
        m_pPanel->SetText("Movie ... Error(AlbumFull)");

        m_TimeToLive = config::NotificationTtl::GetTtlMovieFailure();
        m_Category   = NotificationCategory_Movie;
        m_Priority   = Priority_ResultError;
        return true;
    }

    bool NotificationMovie::SetupAlbumFileCountLimit() NN_NOEXCEPT
    {
        m_pPanel->SetText("Movie ... Error(AlbumLimit)");

        m_TimeToLive = config::NotificationTtl::GetTtlMovieFailure();
        m_Category   = NotificationCategory_Movie;
        m_Priority   = Priority_ResultError;
        return true;
    }

    bool NotificationMovie::SetupFileSystemError() NN_NOEXCEPT
    {
        m_pPanel->SetText("Movie ... Error(FileSystem)");

        m_TimeToLive = config::NotificationTtl::GetTtlMovieFailure();
        m_Category   = NotificationCategory_Movie;
        m_Priority   = Priority_ResultError;
        return true;
    }

}}
