﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationLowBattery.h"

#include <nn/util/util_FormatString.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationLowBattery::NotificationLowBattery() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetLowBatteryTextColor());
        m_pPanel->SetTextPosition(Style::GetLowBatteryTextPositionX(), Style::GetLowBatteryTextPositionY());
        m_pPanel->SetTextSize(Style::GetLowBatteryTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationLowBattery::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationLowBattery::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationLowBattery::SetupLowBattery1(int batteryPercent) NN_NOEXCEPT
    {
        char str[256] = "";
        nn::util::SNPrintf(str, sizeof(str), "Battery Low (%d%%)", batteryPercent);
        m_pPanel->SetText(str);

        m_TimeToLive = config::NotificationTtl::GetTtlLowBattery1();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_LowBattery;
        return true;
    }

    bool NotificationLowBattery::SetupLowBattery2(int batteryPercent) NN_NOEXCEPT
    {
        char str[256] = "";
        nn::util::SNPrintf(str, sizeof(str), "Battery Low (%d%%)", batteryPercent);
        m_pPanel->SetText(str);

        m_TimeToLive = config::NotificationTtl::GetTtlLowBattery2();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_LowBattery;
        return true;
    }

    bool NotificationLowBattery::SetupLowBattery3(int batteryPercent) NN_NOEXCEPT
    {
        char str[256] = "";
        nn::util::SNPrintf(str, sizeof(str), "Battery Low (%d%%)", batteryPercent);
        m_pPanel->SetText(str);

        m_TimeToLive = config::NotificationTtl::GetTtlLowBattery3();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_LowBattery;
        return true;
    }

}}
